/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class ReactorCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    @Override
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation(classNode, "EnableReactor") || AstUtils.hasAtLeastOneFieldOrMethod(classNode, "Reactor");
    }

    @Override
    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses("reactor.core.Reactor").add("reactor-spring-context", false).add("reactor-spring-core", false).add("reactor-core");
    }

    @Override
    public void applyImports(ImportCustomizer imports) {
        imports.addImports(new String[]{"reactor.core.Reactor", "reactor.core.spec.Reactors", "reactor.core.Observable", "reactor.event.Event", "reactor.function.Functions", "reactor.function.Predicates", "reactor.function.Suppliers", "reactor.spring.context.annotation.Consumer", "reactor.spring.context.annotation.Selector", "reactor.spring.context.annotation.SelectorType", "reactor.spring.context.annotation.ReplyTo", "reactor.spring.context.config.EnableReactor"}).addStarImports(new String[]{"reactor.event.selector.Selectors"}).addImport("ReactorEnvironment", "reactor.core.Environment");
    }
}

