/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.types;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import org.grails.datastore.mapping.model.AbstractPersistentProperty;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;

public abstract class Association<T>
extends AbstractPersistentProperty {
    public static final List<CascadeType> DEFAULT_OWNER_CASCADE = Arrays.asList(CascadeType.ALL);
    public static final List<CascadeType> DEFAULT_CHILD_CASCADE = Arrays.asList(CascadeType.PERSIST);
    private PersistentEntity associatedEntity;
    private String referencedPropertyName;
    private boolean owningSide;
    private List<CascadeType> cascadeOperations = new ArrayList<CascadeType>();
    private FetchType fetchStrategy = FetchType.EAGER;

    public Association(PersistentEntity owner, MappingContext context, PropertyDescriptor descriptor) {
        super(owner, context, descriptor);
    }

    public Association(PersistentEntity owner, MappingContext context, String name, Class type) {
        super(owner, context, name, type);
    }

    public FetchType getFetchStrategy() {
        return this.fetchStrategy;
    }

    public void setFetchStrategy(FetchType fetchStrategy) {
        this.fetchStrategy = fetchStrategy;
    }

    public boolean isBidirectional() {
        return this.associatedEntity != null && this.referencedPropertyName != null;
    }

    public Association getInverseSide() {
        PersistentProperty associatedProperty = this.associatedEntity.getPropertyByName(this.referencedPropertyName);
        if (associatedProperty == null) {
            return null;
        }
        if (associatedProperty instanceof Association) {
            return (Association)associatedProperty;
        }
        throw new IllegalMappingException("The inverse side [" + this.associatedEntity.getName() + "." + associatedProperty.getName() + "] of the association [" + this.getOwner().getName() + "." + this.getName() + "] is not valid. Associations can only map to other entities and collection types.");
    }

    public boolean doesCascade(CascadeType cascadeOperation) {
        List<CascadeType> cascades = this.getCascadeOperations();
        return cascadeOperation != null && (cascades.contains(CascadeType.ALL) || cascades.contains(cascadeOperation));
    }

    protected List<CascadeType> getCascadeOperations() {
        List<CascadeType> cascades = this.cascadeOperations.isEmpty() ? (this.isOwningSide() ? DEFAULT_OWNER_CASCADE : DEFAULT_CHILD_CASCADE) : this.cascadeOperations;
        return cascades;
    }

    public boolean isOwningSide() {
        return this.owningSide;
    }

    public void setOwningSide(boolean owningSide) {
        this.owningSide = owningSide;
    }

    public void setAssociatedEntity(PersistentEntity associatedEntity) {
        this.associatedEntity = associatedEntity;
    }

    public PersistentEntity getAssociatedEntity() {
        return this.associatedEntity;
    }

    public void setReferencedPropertyName(String referencedPropertyName) {
        this.referencedPropertyName = referencedPropertyName;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    @Override
    public String toString() {
        return this.getOwner().getName() + "->" + this.getName();
    }

    public boolean isList() {
        return List.class.isAssignableFrom(this.getType());
    }

    public boolean isCircular() {
        PersistentEntity associatedEntity1 = this.getAssociatedEntity();
        if (associatedEntity1 == null) {
            return false;
        }
        return this.isBidirectional() && associatedEntity1.equals(this.getOwner());
    }
}

