/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.types;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;

public class BasicTypeConverterRegistrar {
    public void register(ConverterRegistry registry) {
        registry.addConverter((Converter)new Converter<Date, String>(){

            public String convert(Date date) {
                return String.valueOf(date.getTime());
            }
        });
        registry.addConverter((Converter)new Converter<Date, Calendar>(){

            public Calendar convert(Date date) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                return calendar;
            }
        });
        registry.addConverter((Converter)new Converter<Integer, Long>(){

            public Long convert(Integer integer) {
                return integer.longValue();
            }
        });
        registry.addConverter((Converter)new Converter<Long, Integer>(){

            public Integer convert(Long longValue) {
                return longValue.intValue();
            }
        });
        registry.addConverter((Converter)new Converter<Integer, Double>(){

            public Double convert(Integer integer) {
                return integer.doubleValue();
            }
        });
        registry.addConverter((Converter)new Converter<CharSequence, Date>(){

            public Date convert(CharSequence s) {
                try {
                    Long time = Long.valueOf(s.toString());
                    return new Date(time);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter((Converter)new Converter<CharSequence, Double>(){

            public Double convert(CharSequence s) {
                try {
                    return Double.valueOf(s.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter((Converter)new Converter<CharSequence, Integer>(){

            public Integer convert(CharSequence s) {
                try {
                    return Integer.valueOf(s.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter((Converter)new Converter<CharSequence, Long>(){

            public Long convert(CharSequence s) {
                try {
                    return Long.valueOf(s.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter((Converter)new Converter<Object, String>(){

            public String convert(Object o) {
                return o.toString();
            }
        });
        registry.addConverter((Converter)new Converter<Calendar, String>(){

            public String convert(Calendar calendar) {
                return String.valueOf(calendar.getTime().getTime());
            }
        });
        registry.addConverter((Converter)new Converter<CharSequence, Calendar>(){

            public Calendar convert(CharSequence s) {
                try {
                    Date date = new Date(Long.valueOf(s.toString()));
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTime(date);
                    return c;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }
}

