/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.reflect;

import java.beans.Introspector;
import org.codehaus.groovy.runtime.MetaClassHelper;

public class NameUtils {
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final String PROPERTY_IS_PREFIX = "is";

    public static String getSetterName(String propertyName) {
        return PROPERTY_SET_PREFIX + NameUtils.capitalize(propertyName);
    }

    public static String getGetterName(String propertyName) {
        return NameUtils.getGetterName(propertyName, false);
    }

    public static String getGetterName(String propertyName, boolean useBooleanPrefix) {
        String prefix = useBooleanPrefix ? PROPERTY_IS_PREFIX : PROPERTY_GET_PREFIX;
        return prefix + NameUtils.capitalize(propertyName);
    }

    public static String getPropertyNameForGetterOrSetter(String getterOrSetterName) {
        if (getterOrSetterName == null || getterOrSetterName.length() == 0) {
            return null;
        }
        if (getterOrSetterName.startsWith(PROPERTY_GET_PREFIX) || getterOrSetterName.startsWith(PROPERTY_SET_PREFIX)) {
            return NameUtils.decapitalize(getterOrSetterName.substring(3));
        }
        if (getterOrSetterName.startsWith(PROPERTY_IS_PREFIX)) {
            return NameUtils.decapitalize(getterOrSetterName.substring(2));
        }
        return null;
    }

    public static String decapitalize(String name) {
        return Introspector.decapitalize(name);
    }

    public static String capitalize(String name) {
        return MetaClassHelper.capitalize((String)name);
    }
}

