/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.core.GrailsApplication;
import grails.plugins.exceptions.PluginException;
import groovy.util.slurpersupport.GPathResult;
import groovy.util.slurpersupport.Node;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.grails.plugins.BinaryGrailsPluginDescriptor;
import org.grails.plugins.DefaultGrailsPlugin;
import org.springframework.core.io.Resource;

public class BinaryGrailsPlugin
extends DefaultGrailsPlugin {
    public static final String VIEWS_PROPERTIES = "views.properties";
    public static final String RELATIVE_VIEWS_PROPERTIES = "../gsp/views.properties";
    private BinaryGrailsPluginDescriptor descriptor;
    private Class[] providedArtefacts = new Class[0];
    private Map<String, Class> precompiledViewMap = new HashMap<String, Class>();

    public BinaryGrailsPlugin(Class<?> pluginClass, BinaryGrailsPluginDescriptor descriptor, GrailsApplication application) {
        super(pluginClass, application);
        this.descriptor = descriptor;
        if (descriptor != null) {
            this.initializeProvidedArtefacts(descriptor.getParsedXml());
            this.initializeViewMap(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeViewMap(BinaryGrailsPluginDescriptor descriptor) {
        Resource descriptorResource = descriptor.getResource();
        Resource viewsPropertiesResource = null;
        try {
            viewsPropertiesResource = descriptorResource.createRelative(VIEWS_PROPERTIES);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (viewsPropertiesResource == null || !viewsPropertiesResource.exists()) {
            try {
                viewsPropertiesResource = descriptorResource.createRelative(RELATIVE_VIEWS_PROPERTIES);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (viewsPropertiesResource == null || !viewsPropertiesResource.exists()) {
            return;
        }
        Properties viewsProperties = new Properties();
        InputStream input = null;
        try {
            input = viewsPropertiesResource.getInputStream();
            viewsProperties.load(input);
            for (Object view : viewsProperties.keySet()) {
                String viewName = view.toString();
                String viewClassName = viewsProperties.getProperty(viewName);
                try {
                    Class<?> viewClass = this.application.getClassLoader().loadClass(viewClassName);
                    this.precompiledViewMap.put(viewName, viewClass);
                }
                catch (Throwable e) {
                    throw new PluginException("Failed to initialize view [" + viewName + "] from plugin [" + this.getName() + "] : " + e.getMessage(), e);
                    return;
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error loading views for binary plugin [" + this + "]: " + e.getMessage()), (Throwable)e);
            return;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected void initializeProvidedArtefacts(GPathResult descriptor) {
        GPathResult allResources;
        GPathResult resources;
        ArrayList artefacts = new ArrayList();
        if (descriptor != null && !(resources = (GPathResult)descriptor.getProperty("resources")).isEmpty() && !(allResources = (GPathResult)resources.getProperty("resource")).isEmpty()) {
            ClassLoader classLoader = this.application.getClassLoader();
            Iterator i = allResources.nodeIterator();
            while (i.hasNext()) {
                String className = ((Node)i.next()).text();
                try {
                    artefacts.add(classLoader.loadClass(className));
                }
                catch (Throwable e) {
                    throw new PluginException("Failed to initialize class [" + className + "] from plugin [" + this.getName() + "] : " + e.getMessage(), e);
                }
            }
        }
        artefacts.addAll(Arrays.asList(super.getProvidedArtefacts()));
        this.providedArtefacts = artefacts.toArray(new Class[artefacts.size()]);
    }

    @Override
    public Class<?>[] getProvidedArtefacts() {
        return this.providedArtefacts;
    }

    public BinaryGrailsPluginDescriptor getBinaryDescriptor() {
        return this.descriptor;
    }

    public Resource getResource(String path) {
        Resource descriptorResource = this.descriptor.getResource();
        try {
            Resource resource = descriptorResource.createRelative("static" + path);
            if (resource.exists()) {
                return resource;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public Properties getProperties(Locale locale) {
        Resource i18nDir;
        Resource descriptorResource = this.descriptor.getResource();
        try {
            i18nDir = descriptorResource.createRelative("grails-app/i18n");
        }
        catch (IOException e) {
            return null;
        }
        if (i18nDir == null) {
            return null;
        }
        Properties properties = new Properties();
        String defaultName = this.getBaseMessagesProperties();
        this.attemptLoadProperties(descriptorResource, properties, defaultName);
        for (String filename : this.calculateFilenamesForLocale(defaultName, locale)) {
            this.attemptLoadProperties(descriptorResource, properties, filename);
        }
        return properties;
    }

    private void attemptLoadProperties(Resource descriptorResource, Properties properties, String defaultName) {
        try {
            Resource baseMessagesProperties = descriptorResource.createRelative(defaultName + ".properties");
            if (baseMessagesProperties != null && baseMessagesProperties.exists()) {
                properties.load(baseMessagesProperties.getInputStream());
            }
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to load plugin [" + this + "] properties for name [" + defaultName + "]: " + e.getMessage()), (Throwable)e);
        }
    }

    private String getBaseMessagesProperties() {
        return "grails-app/i18n/" + this.getName() + "-messages";
    }

    protected List<String> calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        temp.append('_');
        if (language.length() > 0) {
            temp.append(language);
            result.add(0, temp.toString());
        }
        temp.append('_');
        if (country.length() > 0) {
            temp.append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0 && (language.length() > 0 || country.length() > 0)) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    public Class resolveView(String viewName) {
        String extraPath = "/plugins/" + this.getName() + '-' + this.getVersion() + '/';
        viewName = viewName.replace(extraPath, "/");
        return this.precompiledViewMap.get(viewName);
    }
}

