/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class SuppressByCommentOutAction
extends SuppressIntentionAction {
    private final String nonNlsCommentPattern;

    SuppressByCommentOutAction(String nonNlsCommentPattern) {
        this.nonNlsCommentPattern = nonNlsCommentPattern;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        IElementType tokenType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/i18n/SuppressByCommentOutAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/i18n/SuppressByCommentOutAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        element = SuppressByCommentOutAction.findJavaCodeUpThere(element);
        PsiFile file = element.getContainingFile();
        editor = InjectedLanguageUtil.openEditorFor((PsiFile)file, (Project)project);
        int endOffset = element.getTextRange().getEndOffset();
        int line = editor.getDocument().getLineNumber(endOffset);
        int lineEndOffset = editor.getDocument().getLineEndOffset(line);
        PsiComment comment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(lineEndOffset - 1), PsiComment.class, (boolean)false);
        String prefix = "";
        boolean prefixFound = false;
        if (comment != null && (tokenType = comment.getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
            prefix = StringUtil.trimStart((String)comment.getText(), (String)"//") + " ";
            prefixFound = true;
        }
        String commentText = "//" + prefix + this.nonNlsCommentPattern;
        if (prefixFound) {
            PsiComment newcom = JavaPsiFacade.getElementFactory((Project)project).createCommentFromText(commentText, element);
            comment.replace((PsiElement)newcom);
        } else {
            editor.getDocument().insertString(lineEndOffset, (CharSequence)(" " + commentText));
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/i18n/SuppressByCommentOutAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/i18n/SuppressByCommentOutAction", "isAvailable"));
        }
        if (!element.isValid()) {
            return false;
        }
        return SuppressByCommentOutAction.findJavaCodeUpThere(element) != null;
    }

    private static PsiElement findJavaCodeUpThere(PsiElement element) {
        while (element != null) {
            if (element.getLanguage() == JavaLanguage.INSTANCE) {
                return element;
            }
            element = element.getContext();
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/SuppressByCommentOutAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = "Suppress with '" + this.nonNlsCommentPattern + "' comment";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/i18n/SuppressByCommentOutAction", "getText"));
        }
        return string;
    }
}

