/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntersectionPackageSet
extends PackageSetBase {
    private final PackageSet myFirstSet;
    private final PackageSet mySecondSet;
    private String myText;

    public IntersectionPackageSet(PackageSet firstSet, PackageSet secondSet) {
        this.myFirstSet = firstSet;
        this.mySecondSet = secondSet;
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull NamedScopesHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/search/scope/packageSet/IntersectionPackageSet", "contains"));
        }
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/packageSet/IntersectionPackageSet", "contains"));
        }
        return (this.myFirstSet instanceof PackageSetBase ? ((PackageSetBase)this.myFirstSet).contains(file, project, holder) : this.myFirstSet.contains(IntersectionPackageSet.getPsiFile(file, project), holder)) && (this.mySecondSet instanceof PackageSetBase ? ((PackageSetBase)this.mySecondSet).contains(file, project, holder) : this.mySecondSet.contains(IntersectionPackageSet.getPsiFile(file, project), holder));
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        IntersectionPackageSet intersectionPackageSet = new IntersectionPackageSet(this.myFirstSet.createCopy(), this.mySecondSet.createCopy());
        if (intersectionPackageSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/IntersectionPackageSet", "createCopy"));
        }
        return intersectionPackageSet;
    }

    @Override
    public int getNodePriority() {
        return 2;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myText == null) {
            boolean needParen;
            StringBuilder buf = new StringBuilder();
            boolean bl = needParen = this.myFirstSet.getNodePriority() > this.getNodePriority();
            if (needParen) {
                buf.append('(');
            }
            buf.append(this.myFirstSet.getText());
            if (needParen) {
                buf.append(')');
            }
            buf.append("&&");
            boolean bl2 = needParen = this.mySecondSet.getNodePriority() > this.getNodePriority();
            if (needParen) {
                buf.append('(');
            }
            buf.append(this.mySecondSet.getText());
            if (needParen) {
                buf.append(')');
            }
            this.myText = buf.toString();
        }
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/IntersectionPackageSet", "getText"));
        }
        return string;
    }

    public PackageSet getFirstSet() {
        return this.myFirstSet;
    }

    public PackageSet getSecondSet() {
        return this.mySecondSet;
    }
}

