/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticationPanel
extends JPanel {
    private JPanel myMainPanel;
    private JLabel myDescriptionLabel;
    private JTextField myLoginTextField;
    private JPasswordField myPasswordTextField;
    private JCheckBox rememberPasswordCheckBox;

    public AuthenticationPanel(@Nullable String description, @Nullable String login, @Nullable String password, @Nullable Boolean rememberPassword) {
        this.$$$setupUI$$$();
        this.add(this.myMainPanel);
        this.myDescriptionLabel.setText(description);
        this.myLoginTextField.setText(login);
        this.myPasswordTextField.setText(password);
        if (rememberPassword == null) {
            this.rememberPasswordCheckBox.setVisible(false);
        } else {
            this.rememberPasswordCheckBox.setSelected(rememberPassword);
        }
    }

    @NotNull
    public String getLogin() {
        String string = StringUtil.notNullize((String)this.myLoginTextField.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/AuthenticationPanel", "getLogin"));
        }
        return string;
    }

    @NotNull
    public char[] getPassword() {
        char[] cArray = (char[])ObjectUtils.notNull((Object)this.myPasswordTextField.getPassword(), (Object)ArrayUtil.EMPTY_CHAR_ARRAY);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/AuthenticationPanel", "getPassword"));
        }
        return cArray;
    }

    public boolean isRememberPassword() {
        return this.rememberPasswordCheckBox.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getLogin().isEmpty() ? this.myLoginTextField : this.myPasswordTextField;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPasswordField jPasswordField;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("##");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 1, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.password"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordTextField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myLoginTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/CommonBundle").getString("editbox.login"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.rememberPasswordCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/CommonBundle").getString("checkbox.remember.password"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

