/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;

public final class PriorityStreamByteDistributor
implements StreamByteDistributor {
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private final WriteVisitor writeVisitor = new WriteVisitor();

    public PriorityStreamByteDistributor(Http2Connection connection) {
        this.connection = ObjectUtil.checkNotNull(connection, "connection");
        this.stateKey = connection.newKey();
        connection.connectionStream().setProperty(this.stateKey, new PriorityState(connection.connectionStream()));
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream stream) {
                stream.setProperty(PriorityStreamByteDistributor.this.stateKey, new PriorityState(stream));
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                PriorityStreamByteDistributor.this.state(stream).close();
            }

            @Override
            public void onPriorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
                long delta;
                Http2Stream parent = stream.parent();
                if (parent != null && (delta = PriorityStreamByteDistributor.this.state(stream).unallocatedStreamableBytesForTree()) != 0L) {
                    PriorityStreamByteDistributor.this.state(parent).unallocatedStreamableBytesForTreeChanged(delta);
                }
            }

            @Override
            public void onPriorityTreeParentChanging(Http2Stream stream, Http2Stream newParent) {
                long delta;
                Http2Stream parent = stream.parent();
                if (parent != null && (delta = PriorityStreamByteDistributor.this.state(stream).unallocatedStreamableBytesForTree()) != 0L) {
                    PriorityStreamByteDistributor.this.state(parent).unallocatedStreamableBytesForTreeChanged(-delta);
                }
            }
        });
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor.StreamState streamState) {
        this.state(streamState.stream()).updateStreamableBytes(streamState.streamableBytes(), streamState.hasFrame());
    }

    @Override
    public boolean distribute(int maxBytes, StreamByteDistributor.Writer writer) {
        ObjectUtil.checkNotNull(writer, "writer");
        if (maxBytes > 0) {
            this.allocateBytesForTree(this.connection.connectionStream(), maxBytes);
        }
        this.writeVisitor.writeAllocatedBytes(writer);
        return this.state(this.connection.connectionStream()).unallocatedStreamableBytesForTree() > 0L;
    }

    int unallocatedStreamableBytes(Http2Stream stream) {
        return this.state(stream).unallocatedStreamableBytes();
    }

    long unallocatedStreamableBytesForTree(Http2Stream stream) {
        return this.state(stream).unallocatedStreamableBytesForTree();
    }

    private int allocateBytesForTree(Http2Stream parent, int connectionWindowSize) {
        PriorityState state = this.state(parent);
        if (state.unallocatedStreamableBytesForTree() <= 0L) {
            return 0;
        }
        if (state.unallocatedStreamableBytesForTree() <= (long)connectionWindowSize) {
            SimpleChildFeeder childFeeder = new SimpleChildFeeder(connectionWindowSize);
            this.forEachChild(parent, childFeeder);
            return childFeeder.bytesAllocated;
        }
        ChildFeeder childFeeder = new ChildFeeder(parent, connectionWindowSize);
        this.forEachChild(parent, childFeeder);
        childFeeder.feedHungryChildren();
        return childFeeder.bytesAllocated;
    }

    private void forEachChild(Http2Stream parent, Http2StreamVisitor childFeeder) {
        try {
            parent.forEachChild(childFeeder);
        }
        catch (Http2Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private PriorityState state(Http2Stream stream) {
        return (PriorityState)ObjectUtil.checkNotNull(stream, "stream").getProperty(this.stateKey);
    }

    private class WriteVisitor
    implements Http2StreamVisitor {
        StreamByteDistributor.Writer writer;
        RuntimeException error;

        private WriteVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeAllocatedBytes(StreamByteDistributor.Writer writer) {
            try {
                this.writer = writer;
                try {
                    PriorityStreamByteDistributor.this.connection.forEachActiveStream(this);
                }
                catch (Http2Exception e) {
                    throw new IllegalStateException(e);
                }
                if (this.error != null) {
                    throw this.error;
                }
            }
            finally {
                this.error = null;
            }
        }

        @Override
        public boolean visit(Http2Stream stream) {
            PriorityState state = PriorityStreamByteDistributor.this.state(stream);
            try {
                int allocated = state.allocated;
                state.resetAllocated();
                if (this.error == null) {
                    this.writer.write(stream, allocated);
                }
            }
            catch (RuntimeException e) {
                this.error = e;
            }
            return true;
        }
    }

    private final class PriorityState {
        final Http2Stream stream;
        boolean hasFrame;
        int streamableBytes;
        int allocated;
        long unallocatedStreamableBytesForTree;

        PriorityState(Http2Stream stream) {
            this.stream = stream;
        }

        void unallocatedStreamableBytesForTreeChanged(long delta) {
            this.unallocatedStreamableBytesForTree += delta;
            if (!this.stream.isRoot()) {
                PriorityStreamByteDistributor.this.state(this.stream.parent()).unallocatedStreamableBytesForTreeChanged(delta);
            }
        }

        void allocate(int bytes) {
            this.allocated += bytes;
            if (bytes != 0) {
                this.unallocatedStreamableBytesForTreeChanged(-bytes);
            }
        }

        void resetAllocated() {
            this.allocate(-this.allocated);
        }

        void updateStreamableBytes(int newStreamableBytes, boolean hasFrame) {
            this.hasFrame = hasFrame;
            int delta = newStreamableBytes - this.streamableBytes;
            if (delta != 0) {
                this.streamableBytes = newStreamableBytes;
                this.unallocatedStreamableBytesForTreeChanged(delta);
            }
        }

        void close() {
            this.resetAllocated();
            this.updateStreamableBytes(0, false);
        }

        boolean hasFrame() {
            return this.hasFrame;
        }

        int unallocatedStreamableBytes() {
            return this.streamableBytes - this.allocated;
        }

        long unallocatedStreamableBytesForTree() {
            return this.unallocatedStreamableBytesForTree;
        }
    }

    private final class SimpleChildFeeder
    implements Http2StreamVisitor {
        int bytesAllocated;
        int connectionWindow;

        SimpleChildFeeder(int connectionWindow) {
            this.connectionWindow = connectionWindow;
        }

        @Override
        public boolean visit(Http2Stream child) {
            PriorityState childState = PriorityStreamByteDistributor.this.state(child);
            int bytesForChild = childState.unallocatedStreamableBytes();
            if (bytesForChild > 0 || childState.hasFrame()) {
                childState.allocate(bytesForChild);
                this.bytesAllocated += bytesForChild;
                this.connectionWindow -= bytesForChild;
            }
            int childBytesAllocated = PriorityStreamByteDistributor.this.allocateBytesForTree(child, this.connectionWindow);
            this.bytesAllocated += childBytesAllocated;
            this.connectionWindow -= childBytesAllocated;
            return true;
        }
    }

    private final class ChildFeeder
    implements Http2StreamVisitor {
        final int maxSize;
        int totalWeight;
        int connectionWindow;
        int nextTotalWeight;
        int nextConnectionWindow;
        int bytesAllocated;
        Http2Stream[] stillHungry;
        int nextTail;

        ChildFeeder(Http2Stream parent, int connectionWindow) {
            this.maxSize = parent.numChildren();
            this.totalWeight = parent.totalChildWeights();
            this.connectionWindow = connectionWindow;
            this.nextConnectionWindow = connectionWindow;
        }

        @Override
        public boolean visit(Http2Stream child) {
            int connectionWindowChunk = Math.max(1, (int)((double)this.connectionWindow * ((double)child.weight() / (double)this.totalWeight)));
            int bytesForTree = Math.min(this.nextConnectionWindow, connectionWindowChunk);
            PriorityState state = PriorityStreamByteDistributor.this.state(child);
            int bytesForChild = Math.min(state.unallocatedStreamableBytes(), bytesForTree);
            if (bytesForChild > 0) {
                state.allocate(bytesForChild);
                this.bytesAllocated += bytesForChild;
                this.nextConnectionWindow -= bytesForChild;
                bytesForTree -= bytesForChild;
            }
            if (bytesForTree > 0) {
                int childBytesAllocated = PriorityStreamByteDistributor.this.allocateBytesForTree(child, bytesForTree);
                this.bytesAllocated += childBytesAllocated;
                this.nextConnectionWindow -= childBytesAllocated;
            }
            if (this.nextConnectionWindow > 0) {
                if (state.unallocatedStreamableBytesForTree() > 0L) {
                    this.stillHungry(child);
                }
                return true;
            }
            return false;
        }

        void feedHungryChildren() {
            if (this.stillHungry == null) {
                return;
            }
            this.totalWeight = this.nextTotalWeight;
            this.connectionWindow = this.nextConnectionWindow;
            int tail = this.nextTail;
            while (tail > 0 && this.connectionWindow > 0) {
                this.nextTotalWeight = 0;
                this.nextTail = 0;
                for (int head = 0; head < tail && this.nextConnectionWindow > 0 && this.visit(this.stillHungry[head]); ++head) {
                }
                this.connectionWindow = this.nextConnectionWindow;
                this.totalWeight = this.nextTotalWeight;
                tail = this.nextTail;
            }
        }

        void stillHungry(Http2Stream child) {
            this.ensureSpaceIsAllocated(this.nextTail);
            this.stillHungry[this.nextTail++] = child;
            this.nextTotalWeight += child.weight();
        }

        void ensureSpaceIsAllocated(int index) {
            if (this.stillHungry == null) {
                this.stillHungry = new Http2Stream[Math.max(2, this.maxSize >>> 2)];
            } else if (index == this.stillHungry.length) {
                this.stillHungry = Arrays.copyOf(this.stillHungry, Math.min(this.maxSize, this.stillHungry.length << 1));
            }
        }
    }
}

