/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AntConfiguration
extends SimpleModificationTracker {
    private final Project myProject;
    @NonNls
    public static final String ACTION_ID_PREFIX = "Ant_";
    private static final Key<Boolean> ANT_SUPPORT_INITIALIZED_KEY = new Key("AntSupportInitialized");

    protected AntConfiguration(Project project) {
        this.myProject = project;
    }

    public static AntConfiguration getInstance(Project project) {
        return (AntConfiguration)((Object)ServiceManager.getService((Project)project, AntConfiguration.class));
    }

    public static void initAntSupport(Project project) {
        if (!Boolean.TRUE.equals(project.getUserData(ANT_SUPPORT_INITIALIZED_KEY))) {
            ServiceManager.getService((Project)project, AntConfiguration.class);
            project.putUserData(ANT_SUPPORT_INITIALIZED_KEY, (Object)Boolean.TRUE);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public static String getActionIdPrefix(Project project) {
        return ACTION_ID_PREFIX + project.getLocationHash();
    }

    public abstract boolean isInitialized();

    public abstract AntBuildFile[] getBuildFiles();

    public abstract AntBuildFile addBuildFile(VirtualFile var1) throws AntNoFileException;

    public abstract void removeBuildFile(AntBuildFile var1);

    public abstract void addAntConfigurationListener(AntConfigurationListener var1);

    public abstract void removeAntConfigurationListener(AntConfigurationListener var1);

    public abstract AntBuildTarget[] getMetaTargets(AntBuildFile var1);

    public abstract void updateBuildFile(AntBuildFile var1);

    @Nullable
    public abstract AntBuildModel getModelIfRegistered(AntBuildFile var1);

    public abstract AntBuildModel getModel(AntBuildFile var1);

    @Nullable
    public abstract AntBuildFile findBuildFileByActionId(String var1);

    public abstract boolean executeTargetBeforeCompile(DataContext var1);

    public abstract boolean executeTargetAfterCompile(DataContext var1);
}

