/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AntDomPropertyDefiningElement
extends AntDomElement
implements PropertiesProvider {
    @Override
    @NotNull
    public final Iterator<String> getNamesIterator() {
        List<GenericAttributeValue<String>> attribs = this.getPropertyDefiningAttributes();
        ArrayList<String> result = new ArrayList<String>(attribs.size());
        for (GenericAttributeValue<String> attribValue : attribs) {
            String name = attribValue.getStringValue();
            if (name == null || name.length() <= 0) continue;
            result.add(name);
        }
        for (String name : this.getImplicitPropertyNames()) {
            result.add(name);
        }
        Iterator<String> iterator = result.iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomPropertyDefiningElement", "getNamesIterator"));
        }
        return iterator;
    }

    @Override
    public final PsiElement getNavigationElement(String propertyName) {
        for (GenericAttributeValue<String> value : this.getPropertyDefiningAttributes()) {
            if (!propertyName.equals(value.getStringValue())) continue;
            DomTarget domTarget = DomTarget.getTarget((DomElement)this, value);
            return domTarget != null ? PomService.convertToPsi((PsiTarget)domTarget) : null;
        }
        for (String propName : this.getImplicitPropertyNames()) {
            if (!propertyName.equals(propName)) continue;
            DomTarget domTarget = DomTarget.getTarget((DomElement)this);
            if (domTarget != null) {
                return PomService.convertToPsi((PsiTarget)domTarget);
            }
            XmlElement xmlElement = this.getXmlElement();
            return xmlElement != null ? xmlElement.getNavigationElement() : null;
        }
        return null;
    }

    @Override
    public final String getPropertyValue(String propertyName) {
        for (GenericAttributeValue<String> value : this.getPropertyDefiningAttributes()) {
            if (!propertyName.equals(value.getStringValue())) continue;
            return this.calcPropertyValue(propertyName);
        }
        for (String implicitPropName : this.getImplicitPropertyNames()) {
            if (!propertyName.equals(implicitPropName)) continue;
            return this.calcPropertyValue(propertyName);
        }
        return null;
    }

    protected List<GenericAttributeValue<String>> getPropertyDefiningAttributes() {
        return Collections.emptyList();
    }

    protected List<String> getImplicitPropertyNames() {
        return Collections.emptyList();
    }

    protected String calcPropertyValue(String propertyName) {
        return "";
    }
}

