/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts.importToCvs;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.ImportConfiguration;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.cvsSupport2.ui.experts.importToCvs.FileExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CustomizeKeywordSubstitutionDialog
extends DialogWrapper {
    private static final DefaultCellEditor EDITOR = new DefaultCellEditor(new JComboBox<Object>(KeywordSubstitutionWrapper.values().toArray()));
    private static final DefaultTableCellRenderer RENDERER = new DefaultTableCellRenderer();
    private static final ColumnInfo KEYWORD_SUBSTITUTION = new ColumnInfo<FileExtension, KeywordSubstitutionWrapper>(CvsBundle.message((String)"import.wizard.keyword.substitution.column.name", (Object[])new Object[0])){

        public KeywordSubstitutionWrapper valueOf(FileExtension extension) {
            return extension.getKeywordSubstitution();
        }

        public Comparator<FileExtension> getComparator() {
            return new Comparator<FileExtension>(){

                @Override
                public int compare(FileExtension extension1, FileExtension extension2) {
                    KeywordSubstitutionWrapper firstSubstitution = (KeywordSubstitutionWrapper)extension1.getKeywordSubstitutionsWithSelection().getSelection();
                    KeywordSubstitutionWrapper secondSubstitution = (KeywordSubstitutionWrapper)extension2.getKeywordSubstitutionsWithSelection().getSelection();
                    return firstSubstitution.toString().compareTo(secondSubstitution.toString());
                }
            };
        }

        public boolean isCellEditable(FileExtension extension) {
            return true;
        }

        public void setValue(FileExtension extension, KeywordSubstitutionWrapper aValue) {
            extension.setKeywordSubstitution(aValue);
        }

        public TableCellRenderer getRenderer(FileExtension extension) {
            return RENDERER;
        }

        public TableCellEditor getEditor(FileExtension extension) {
            return EDITOR;
        }

        public int getAdditionalWidth() {
            return 20;
        }

        public String getMaxStringValue() {
            return KeywordSubstitutionWrapper.KEYWORD_EXPANSION_LOCKER.toString();
        }
    };
    private static final ColumnInfo EXTENSION_COLUMN = new ColumnInfo<FileExtension, String>(CvsBundle.message((String)"import.wizard.file.extension.column.name", (Object[])new Object[0])){

        public String valueOf(FileExtension o) {
            return o.getExtension();
        }

        public Comparator<FileExtension> getComparator() {
            return new Comparator<FileExtension>(){

                @Override
                public int compare(FileExtension extension1, FileExtension extension2) {
                    return extension1.getExtension().compareTo(extension2.getExtension());
                }
            };
        }

        public int getAdditionalWidth() {
            return 50;
        }

        public String getMaxStringValue() {
            return this.getName();
        }
    };
    private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{EXTENSION_COLUMN, KEYWORD_SUBSTITUTION};
    private final ListTableModel<FileExtension> myModel;
    private final ImportConfiguration myImportConfiguration;

    public CustomizeKeywordSubstitutionDialog(Project project, String description, ImportConfiguration importConfiguration) {
        super(project);
        this.setTitle(description);
        this.myImportConfiguration = importConfiguration;
        this.myModel = new ListTableModel(COLUMNS);
        this.myModel.setItems(this.collectFileTypes());
        this.init();
        this.pack();
    }

    private List<FileExtension> collectFileTypes() {
        FileType[] fileTypes;
        Collection<FileExtension> storedExtensions = this.myImportConfiguration.getExtensions();
        ArrayList<FileExtension> result = new ArrayList<FileExtension>();
        result.addAll(storedExtensions);
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            String[] extensions;
            for (String extension : extensions = FileTypeManager.getInstance().getAssociatedExtensions(fileType)) {
                FileExtension fileExtension = new FileExtension(extension);
                if (result.contains(fileExtension)) continue;
                result.add(fileExtension);
            }
        }
        return result;
    }

    protected void doOKAction() {
        this.myImportConfiguration.setExtensions(this.myModel.getItems());
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        TableView table = new TableView(this.myModel);
        Dimension preferredSize = table.getPreferredSize();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)table);
        Dimension scrollPaneSize = scrollPane.getPreferredSize();
        scrollPaneSize.width = preferredSize.width;
        scrollPane.setPreferredSize(scrollPaneSize);
        return scrollPane;
    }

    public List<FileExtension> getFileExtensions() {
        return this.myModel.getItems();
    }
}

