/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.groovy;

import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.java.LanguageReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatterns;

public class GrLanguageReferenceProvider
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/plugins/intelliLang/inject/groovy/GrLanguageReferenceProvider", "registerReferenceProviders"));
        }
        Configuration configuration = Configuration.getInstance();
        registrar.registerReferenceProvider((ElementPattern)((GroovyElementPattern.Capture)GroovyPatterns.groovyLiteralExpression().annotationParam((ElementPattern)StandardPatterns.string().with(GrLanguageReferenceProvider.isLanguageAnnotation(configuration)), "value")).and((ElementPattern)GroovyPatterns.groovyLiteralExpression().with(GrLanguageReferenceProvider.isStringLiteral())), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/intelliLang/inject/groovy/GrLanguageReferenceProvider$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/intelliLang/inject/groovy/GrLanguageReferenceProvider$1", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new LanguageReference((PsiLiteral)element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/groovy/GrLanguageReferenceProvider$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static PatternCondition<GrLiteral> isStringLiteral() {
        return new PatternCondition<GrLiteral>("isStringLiteral"){

            public boolean accepts(@NotNull GrLiteral expression, ProcessingContext context) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/plugins/intelliLang/inject/groovy/GrLanguageReferenceProvider$2", "accepts"));
                }
                return expression.getValue() instanceof String;
            }
        };
    }

    private static PatternCondition<String> isLanguageAnnotation(final Configuration configuration) {
        return new PatternCondition<String>("isLanguageAnnotation"){

            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/intellij/plugins/intelliLang/inject/groovy/GrLanguageReferenceProvider$3", "accepts"));
                }
                return Comparing.equal((String)configuration.getAdvancedConfiguration().getLanguageAnnotationClass(), (String)s);
            }
        };
    }
}

