/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.ui;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import org.intellij.plugins.xsltDebugger.ui.AbstractTabComponent;
import org.intellij.plugins.xsltDebugger.ui.GeneratedStructureModel;
import org.intellij.plugins.xsltDebugger.ui.SmartStructureTracker;
import org.intellij.plugins.xsltDebugger.ui.StructureTree;
import org.intellij.plugins.xsltDebugger.ui.StructureTreeExpander;
import org.intellij.plugins.xsltDebugger.ui.actions.HideWhitespaceAction;
import org.jetbrains.annotations.NotNull;

public class StructureTabComponent
extends AbstractTabComponent {
    private static final Key<StructureTabComponent> KEY = Key.create((String)"STRUCTURE");
    private final DefaultActionGroup myToolbarActions;
    private final JComponent myComponent;
    private final GeneratedStructureModel myEventModel = new GeneratedStructureModel();

    private StructureTabComponent(Disposable disposable) {
        super("Structure");
        StructureTree tree = new StructureTree(this.myEventModel);
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)((Object)tree));
        this.myEventModel.addTreeModelListener((TreeModelListener)((Object)new SmartStructureTracker((JTree)((Object)tree), disposable)));
        DefaultActionGroup structureActions = new DefaultActionGroup();
        StructureTreeExpander expander = new StructureTreeExpander((JTree)((Object)tree));
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        structureActions.add((AnAction)new HideWhitespaceAction(tree, this.myEventModel));
        structureActions.add(actionsManager.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)tree)));
        structureActions.add(actionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)tree)));
        this.myToolbarActions = structureActions;
    }

    public GeneratedStructureModel getEventModel() {
        return this.myEventModel;
    }

    public static StructureTabComponent create(ProcessHandler process, Disposable disposable) {
        StructureTabComponent component = new StructureTabComponent(disposable);
        process.putUserData(KEY, (Object)component);
        return component;
    }

    public static StructureTabComponent getInstance(ProcessHandler process) {
        return (StructureTabComponent)((Object)process.getUserData(KEY));
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/ui/StructureTabComponent", "getComponent"));
        }
        return jComponent;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getComponent();
    }

    public ActionGroup getToolbarActions() {
        return this.myToolbarActions;
    }
}

