/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.incremental.components.LocationInfo;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001b\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\r\u0001e\t\u0001\u0014AQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0001\u0005\u0004S-!1\n\u0003E\u0004\u001b\ta\t\u0001\u0007\u0003\u001dWE\u001b1!\u0004\u0002\u0005\n!)\u0001"}, strings={"Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "location", "Lorg/jetbrains/kotlin/incremental/components/LocationInfo;", "getLocation", "()Lorg/jetbrains/kotlin/incremental/components/LocationInfo;"}, moduleName="kotlin-compiler")
public final class KotlinLookupLocation
implements LookupLocation {
    @NotNull
    private final KtElement element;

    @Override
    @Nullable
    public LocationInfo getLocation() {
        KtFile containingJetFile = this.element.getContainingKtFile();
        if (KtPsiFactoryKt.getDoNotAnalyze(containingJetFile) != null) {
            return null;
        }
        return new LocationInfo(this, containingJetFile){
            @NotNull
            private final String filePath;
            final /* synthetic */ KotlinLookupLocation this$0;
            final /* synthetic */ KtFile $containingJetFile;

            @NotNull
            public String getFilePath() {
                return this.filePath;
            }

            @NotNull
            public LocationInfo.Position getPosition() {
                DiagnosticUtils.LineAndColumn $receiver = DiagnosticUtils.getLineAndColumnInPsiFile(this.$containingJetFile, this.this$0.getElement().getTextRange());
                DiagnosticUtils.LineAndColumn it = $receiver;
                return new LocationInfo.Position(it.getLine(), it.getColumn());
            }
            {
                this.this$0 = $outer;
                this.$containingJetFile = $captured_local_variable$1;
                this.filePath = $captured_local_variable$1.getVirtualFile().getPath();
            }
        };
    }

    @NotNull
    public final KtElement getElement() {
        return this.element;
    }

    public KotlinLookupLocation(@NotNull KtElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        this.element = element;
    }
}

