/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.HashSet;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypeDelegation;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.NullAwareness;
import org.jetbrains.kotlin.types.SubtypingRepresentatives;
import org.jetbrains.kotlin.types.TypeCapability;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\f\u0015\tA!B\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Aa\u0003\u0007\u0001!GI\u0012\u0001'\u0001\u001a\u0003a\t\u0011$\u0001M\u00023\u0005A\"!(A\u0012C?!!!C\u0002\t\u00065\t\u0001dA\u0005\u0004\u0011\u000fi\u0011\u0001G\u0002\n\u0007!!Q\"\u0001M\u0005#\u000e\t\u0001\"B\u0013\u0005\t-A!\"D\u0001\u0019\r\u0015\u001eBa\u0003E\u000b\u001b\ta\t\u0001J\u0006\u0012\t\u0011\u0001\u0001bC\u000b\u00021/Ib\u0001\u0003\u0007\u000e\t%\u0011\u0011\"\u0001\u0013\f13\t6!\u0001\u0005\u000eK\u0011!!\u0002c\u0007\u000e\u0003a\u0019Q\u0005\u0002\u0003\f\u00119i\u0011\u0001\u0007\u0004&\u0011\u0011Y\u0001RD\u0007\u00021\rI2\u0001C\b\u000e\u0003a1Q\u0005\u0002\u0003\u0002\u0011?i\u0011\u0001\u0007\t&\t\u0011Y\u0001\u0012E\u0007\u00021EIs\u0001B!\u001d\u0011\u0017i\u0011\u0001\u0007\u0004R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0017\"Ai!D\u0001\u0019\u0007qY\u0013kA\u0002\u000e\u0005\u00119\u0001rB\u0015\u000b\t-C\u0001\u0002B\u0007\u00021\u0013\t6\u0001B\u0003\u0001\u001b\t!\u0001\u0002#\u0005*\u0015\u0011Y\u0005\u0002#\u0002\u000e\u0003a\u0019\u0011k\u0001\u0003\u0006\u00015\u0011A!\u0003E\bS)!1\n\u0003E\u0004\u001b\u0005A2!U\u0002\u0005\u000b\u0001i!\u0001b\u0005\t\u0010\u0001"}, strings={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType;", "Lorg/jetbrains/kotlin/types/DelegatingType;", "Lorg/jetbrains/kotlin/types/NullAwareness;", "Lorg/jetbrains/kotlin/types/Flexibility;", "Lorg/jetbrains/kotlin/types/FlexibleTypeDelegation;", "lowerBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "extraCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;)V", "assertionsDone", "", "delegateType", "getDelegateType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getExtraCapabilities", "()Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;", "getLowerBound", "getUpperBound", "computeIsNullable", "getCapability", "T", "Lorg/jetbrains/kotlin/types/TypeCapability;", "capabilityClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/types/TypeCapability;", "getDelegate", "isMarkedNullable", "makeNullableAsSpecified", "nullable", "runAssertions", "", "toString", "", "Companion"}, moduleName="kotlin-compiler")
public class DelegatingFlexibleType
extends DelegatingType
implements Flexibility,
FlexibleTypeDelegation,
NullAwareness {
    @NotNull
    public static final HashSet<Class<? extends TypeCapability>> capabilityClasses;
    private boolean assertionsDone;
    @NotNull
    private final KotlinType lowerBound;
    @NotNull
    private final KotlinType upperBound;
    @NotNull
    private final FlexibleTypeCapabilities extraCapabilities;
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.types.DelegatingFlexibleType$Companion.INSTANCE;
        capabilityClasses = SetsKt.hashSetOf(NullAwareness.class, Flexibility.class, SubtypingRepresentatives.class, FlexibleTypeDelegation.class);
    }

    private final void runAssertions() {
        Unit unit;
        Unit unit2;
        Unit unit3;
        Unit unit4;
        if (this.assertionsDone || !PreconditionsKt.getASSERTIONS_ENABLED()) {
            return;
        }
        this.assertionsDone = true;
        boolean value2 = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit4 = Unit.INSTANCE;
        } else {
            unit4 = Unit.INSTANCE;
        }
        value2 = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = Unit.INSTANCE;
        }
        value2 = Intrinsics.areEqual(this.getLowerBound(), this.getUpperBound()) ^ true;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        value2 = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value2) {
                String message = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
    }

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        T extra = this.getExtraCapabilities().getCapability(capabilityClass, this, this);
        if (extra != null) {
            return extra;
        }
        if (Companion.getCapabilityClasses$kotlin_compiler().contains(capabilityClass)) {
            DelegatingFlexibleType delegatingFlexibleType = this;
            if (delegatingFlexibleType == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)delegatingFlexibleType;
        }
        return super.getCapability(capabilityClass);
    }

    @Override
    @NotNull
    public KotlinType makeNullableAsSpecified(boolean nullable2) {
        KotlinType kotlinType = TypeUtils.makeNullableAsSpecified(this.getLowerBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.makeNullableAs\u2026ied(lowerBound, nullable)");
        KotlinType kotlinType2 = TypeUtils.makeNullableAsSpecified(this.getUpperBound(), nullable2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNullableAs\u2026ied(upperBound, nullable)");
        return Companion.create(kotlinType, kotlinType2, this.getExtraCapabilities());
    }

    @Override
    public boolean computeIsNullable() {
        return this.getDelegateType().isMarkedNullable();
    }

    @Override
    public boolean isMarkedNullable() {
        NullAwareness nullAwareness = this.getCapability(NullAwareness.class);
        if (nullAwareness == null) {
            Intrinsics.throwNpe();
        }
        return nullAwareness.computeIsNullable();
    }

    @Override
    @NotNull
    public KotlinType getDelegateType() {
        this.runAssertions();
        return this.getLowerBound();
    }

    @Override
    @NotNull
    protected KotlinType getDelegate() {
        FlexibleTypeDelegation flexibleTypeDelegation = this.getCapability(FlexibleTypeDelegation.class);
        if (flexibleTypeDelegation == null) {
            Intrinsics.throwNpe();
        }
        return flexibleTypeDelegation.getDelegateType();
    }

    @Override
    @NotNull
    public String toString() {
        return "('" + this.getLowerBound() + "'..'" + this.getUpperBound() + "')";
    }

    @Override
    @NotNull
    public KotlinType getLowerBound() {
        return this.lowerBound;
    }

    @Override
    @NotNull
    public KotlinType getUpperBound() {
        return this.upperBound;
    }

    @Override
    @NotNull
    public FlexibleTypeCapabilities getExtraCapabilities() {
        return this.extraCapabilities;
    }

    protected DelegatingFlexibleType(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.extraCapabilities = extraCapabilities;
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        return Flexibility.DefaultImpls.getSubTypeRepresentative(this);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        return Flexibility.DefaultImpls.getSuperTypeRepresentative(this);
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return Flexibility.DefaultImpls.sameTypeConstructor(this, type2);
    }

    @JvmStatic
    @NotNull
    public static final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
        Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
        Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
        Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
        return Companion.create(lowerBound, upperBound, extraCapabilities);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0005C\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u00063\rAa!D\u0001\u0019\u000be\u0019\u0001RB\u0007\u00021\u001dI#\u0003\u0002!\t\u0011\u0007i\u0001\"\u0003\u0004\n\u000b%\u0019A\u0011A\u0005\u00021\rA*\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011\u001d\u0001\u0002\u0002"}, strings={"Lorg/jetbrains/kotlin/types/DelegatingFlexibleType$Companion;", "", "()V", "capabilityClasses", "Ljava/util/HashSet;", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/types/TypeCapability;", "getCapabilityClasses$kotlin_compiler", "()Ljava/util/HashSet;", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "lowerBound", "upperBound", "extraCapabilities", "Lorg/jetbrains/kotlin/types/FlexibleTypeCapabilities;"}, moduleName="kotlin-compiler")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final HashSet<Class<? extends TypeCapability>> getCapabilityClasses$kotlin_compiler() {
            return capabilityClasses;
        }

        @JvmStatic
        @NotNull
        public final KotlinType create(@NotNull KotlinType lowerBound, @NotNull KotlinType upperBound, @NotNull FlexibleTypeCapabilities extraCapabilities) {
            Intrinsics.checkParameterIsNotNull(lowerBound, "lowerBound");
            Intrinsics.checkParameterIsNotNull(upperBound, "upperBound");
            Intrinsics.checkParameterIsNotNull(extraCapabilities, "extraCapabilities");
            if (Intrinsics.areEqual(lowerBound, upperBound)) {
                return lowerBound;
            }
            return new DelegatingFlexibleType(lowerBound, upperBound, extraCapabilities);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

