/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.psi.XPath2ElementVisitor;
import org.intellij.lang.xpath.psi.XPath2For;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariableDeclaration;
import org.intellij.lang.xpath.psi.impl.XPath2ElementImpl;
import org.jetbrains.annotations.NotNull;

public class XPath2ForImpl
extends XPath2ElementImpl
implements XPath2For {
    public XPath2ForImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathExpression value = this.getReturn();
        XPathType xPathType = value != null ? value.getType() : XPathType.UNKNOWN;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2ForImpl", "getType"));
        }
        return xPathType;
    }

    @Override
    @NotNull
    public XPathVariableDeclaration[] getVariables() {
        XPathVariableDeclaration[] xPathVariableDeclarationArray = (XPathVariableDeclaration[])this.findChildrenByClass(XPathVariableDeclaration.class);
        if (xPathVariableDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPath2ForImpl", "getVariables"));
        }
        return xPathVariableDeclarationArray;
    }

    @Override
    public XPathExpression getReturn() {
        ASTNode node = this.getNode().findChildByType(XPath2ElementTypes.BODY);
        return node != null ? (XPathExpression)PsiTreeUtil.findChildOfType((PsiElement)node.getPsi(), XPathExpression.class) : null;
    }

    @Override
    public void accept(XPath2ElementVisitor visitor) {
        visitor.visitXPath2For(this);
    }
}

