/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.support.jaxen;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlToken;
import org.intellij.plugins.xpathView.support.jaxen.NodeIterator;

class PsiChildAxisIterator
extends NodeIterator {
    public PsiChildAxisIterator(Object contextNode) {
        super((PsiElement)contextNode);
    }

    @Override
    protected PsiElement getFirstNode(PsiElement contextNode) {
        PsiElement n = contextNode.getFirstChild();
        n = this.skipToXmlElement(n);
        return n;
    }

    @Override
    protected PsiElement getNextNode(PsiElement contextNode) {
        PsiElement n = contextNode.getNextSibling();
        n = this.skipToXmlElement(n);
        return n;
    }

    private PsiElement skipToXmlElement(PsiElement n) {
        while (n != null && (!this.isXmlElement(n) || this.isXmlToken(n) || this.isAttribute(n))) {
            n = n.getNextSibling();
        }
        return n;
    }

    private boolean isAttribute(PsiElement n) {
        return n instanceof XmlAttribute;
    }

    private boolean isXmlElement(PsiElement n) {
        return n instanceof XmlElement || n instanceof PsiWhiteSpace;
    }

    private boolean isXmlToken(PsiElement n) {
        return n instanceof XmlToken;
    }
}

