/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.internal.repository.archives.ArchFilter;
import com.android.sdklib.internal.repository.archives.BitSize;
import com.android.sdklib.internal.repository.archives.HostOs;
import com.android.sdklib.internal.repository.archives.LegacyArch;
import com.android.sdklib.internal.repository.archives.LegacyOs;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import java.util.Properties;
import org.w3c.dom.Node;

@Deprecated
public class PackageParserUtils {
    @NonNull
    public static ArchFilter parseArchFilter(@NonNull Node archiveNode) {
        LegacyArch a;
        String hos = PackageParserUtils.getOptionalXmlString(archiveNode, "host-os");
        String hb = PackageParserUtils.getOptionalXmlString(archiveNode, "host-bits");
        String jb = PackageParserUtils.getOptionalXmlString(archiveNode, "jvm-bits");
        String mjv = PackageParserUtils.getOptionalXmlString(archiveNode, "min-jvm-version");
        if (hos != null || hb != null || jb != null || mjv != null) {
            NoPreviewRevision rev = null;
            try {
                rev = NoPreviewRevision.parseRevision(mjv);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new ArchFilter(HostOs.fromXmlName(hos), BitSize.fromXmlName(hb), BitSize.fromXmlName(jb), rev);
        }
        Properties props = new Properties();
        LegacyOs o = (LegacyOs)((Object)PackageParserUtils.getEnumAttribute(archiveNode, "os", (Object[])LegacyOs.values(), null));
        if (o != null) {
            props.setProperty("Archive.Os", o.toString());
        }
        if ((a = (LegacyArch)((Object)PackageParserUtils.getEnumAttribute(archiveNode, "arch", (Object[])LegacyArch.values(), null))) != null) {
            props.setProperty("Archive.Arch", a.toString());
        }
        return new ArchFilter(props);
    }

    public static FullRevision parseFullRevisionElement(Node revisionNode) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        int preview = 0;
        if (revisionNode != null) {
            if (PackageParserUtils.findChildElement(revisionNode, "major") != null) {
                major = PackageParserUtils.getXmlInt(revisionNode, "major", 0);
                minor = PackageParserUtils.getXmlInt(revisionNode, "minor", 0);
                micro = PackageParserUtils.getXmlInt(revisionNode, "micro", 0);
                preview = PackageParserUtils.getXmlInt(revisionNode, "preview", 0);
            } else {
                try {
                    String majorStr = revisionNode.getTextContent().trim();
                    major = Integer.parseInt(majorStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new FullRevision(major, minor, micro, preview);
    }

    public static NoPreviewRevision parseNoPreviewRevisionElement(Node revisionNode) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        if (revisionNode != null) {
            if (PackageParserUtils.findChildElement(revisionNode, "major") != null) {
                major = PackageParserUtils.getXmlInt(revisionNode, "major", 0);
                minor = PackageParserUtils.getXmlInt(revisionNode, "minor", 0);
                micro = PackageParserUtils.getXmlInt(revisionNode, "micro", 0);
            } else {
                try {
                    String majorStr = revisionNode.getTextContent().trim();
                    major = Integer.parseInt(majorStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new NoPreviewRevision(major, minor, micro);
    }

    public static Node findChildElement(Node node, String xmlLocalName) {
        if (node != null) {
            String nsUri = node.getNamespaceURI();
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                String nsUriChild = child.getNamespaceURI();
                if ((nsUri != null || nsUriChild != null) && (nsUri == null || !nsUri.equals(nsUriChild)) || xmlLocalName != null && !xmlLocalName.equals(child.getLocalName())) continue;
                return child;
            }
        }
        return null;
    }

    public static String getXmlString(Node node, String xmlLocalName) {
        return PackageParserUtils.getXmlString(node, xmlLocalName, "");
    }

    public static String getXmlString(Node node, String xmlLocalName, String defaultValue) {
        Node child = PackageParserUtils.findChildElement(node, xmlLocalName);
        String content = child == null ? null : child.getTextContent();
        return content == null || content.isEmpty() ? defaultValue : content;
    }

    public static String getOptionalXmlString(Node node, String xmlLocalName) {
        Node child = PackageParserUtils.findChildElement(node, xmlLocalName);
        return child == null ? null : child.getTextContent();
    }

    public static int getXmlInt(Node node, String xmlLocalName, int defaultValue) {
        String s = PackageParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getXmlLong(Node node, String xmlLocalName, long defaultValue) {
        String s = PackageParserUtils.getXmlString(node, xmlLocalName);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Object getEnumAttribute(Node archiveNode, String attrName, Object[] values, Object defaultValue) {
        Node attr = archiveNode.getAttributes().getNamedItem(attrName);
        if (attr != null) {
            String found = attr.getNodeValue();
            for (Object value : values) {
                if (!value.toString().equalsIgnoreCase(found)) continue;
                return value;
            }
        }
        return defaultValue;
    }

    @Nullable
    public static String getProperty(@Nullable Properties props, @NonNull String propKey, @Nullable String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        return props.getProperty(propKey, defaultValue);
    }

    public static int getPropertyInt(@Nullable Properties props, @NonNull String propKey, int defaultValue) {
        String s;
        String string = s = props != null ? props.getProperty(propKey, null) : null;
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Nullable
    public static FullRevision getPropertyFull(@Nullable Properties props, @NonNull String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        FullRevision rev = null;
        if (revStr != null) {
            try {
                rev = FullRevision.parseRevision(revStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rev;
    }

    @Nullable
    public static MajorRevision getPropertyMajor(@Nullable Properties props, @NonNull String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        MajorRevision rev = null;
        if (revStr != null) {
            try {
                rev = MajorRevision.parseRevision(revStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rev;
    }

    @Nullable
    public static NoPreviewRevision getPropertyNoPreview(@Nullable Properties props, @NonNull String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        NoPreviewRevision rev = null;
        if (revStr != null) {
            try {
                rev = NoPreviewRevision.parseRevision(revStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rev;
    }
}

