/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import java.io.InputStream;

public class SdkAddonsListConstants {
    private static final String NS_BASE = "http://schemas.android.com/sdk/android/addons-list/";
    public static final String NS_PATTERN = "http://schemas.android.com/sdk/android/addons-list/([1-9][0-9]*)";
    public static final int NS_LATEST_VERSION = 2;
    public static final String NS_URI = SdkAddonsListConstants.getSchemaUri(2);
    public static final String URL_DEFAULT_FILENAME = SdkAddonsListConstants.getDefaultName(2);
    public static final String URL_ADDON_LIST = "https://dl.google.com/android/repository/" + URL_DEFAULT_FILENAME;
    public static final String NODE_SDK_ADDONS_LIST = "sdk-addons-list";
    public static final String NODE_ADDON_SITE = "addon-site";
    public static final String NODE_SYS_IMG_SITE = "sys-img-site";
    public static final String NODE_NAME = "name";
    public static final String NODE_URL = "url";

    public static InputStream getXsdStream(int version) {
        String filename = String.format("sdk-addons-list-%d.xsd", version);
        return SdkAddonsListConstants.class.getResourceAsStream(filename);
    }

    public static String getSchemaUri(int version) {
        return String.format("http://schemas.android.com/sdk/android/addons-list/%d", version);
    }

    public static String getDefaultName(int version) {
        return String.format("addons_list-%1$d.xml", version);
    }
}

