/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;

public class BuildTargetTypeState {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.storage.BuildTargetTypeState");
    private final Map<BuildTarget<?>, Integer> myTargetIds;
    private final ConcurrentMap<BuildTarget<?>, BuildTargetConfiguration> myConfigurations;
    private final BuildTargetType<?> myTargetType;
    private final BuildTargetsState myTargetsState;
    private final File myTargetsFile;

    public BuildTargetTypeState(BuildTargetType<?> targetType, BuildTargetsState state) {
        this.myTargetType = targetType;
        this.myTargetsState = state;
        this.myTargetsFile = new File(state.getDataPaths().getTargetTypeDataRoot(targetType), "targets.dat");
        this.myConfigurations = new ConcurrentHashMap(16, 0.75f, 1);
        this.myTargetIds = new HashMap();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load() {
        boolean bl;
        if (!this.myTargetsFile.exists()) {
            return false;
        }
        DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myTargetsFile)));
        try {
            input.readInt();
            int size = input.readInt();
            BuildTargetLoader<?> loader = this.myTargetType.createLoader(this.myTargetsState.getModel());
            while (size-- > 0) {
                String stringId = IOUtil.readString((DataInput)input);
                int intId = input.readInt();
                this.myTargetsState.markUsedId(intId);
                Object target = loader.createTarget(stringId);
                if (target != null) {
                    this.myTargetIds.put((BuildTarget<?>)target, intId);
                    continue;
                }
                LOG.info("Unknown " + this.myTargetType.getTypeId() + " target: " + stringId);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                input.close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.info("Cannot load " + this.myTargetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        input.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        try {
            FileUtil.createParentDirs((File)this.myTargetsFile);
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.myTargetsFile)));
            try {
                output.writeInt(0);
                output.writeInt(this.myTargetIds.size());
                for (Map.Entry<BuildTarget<?>, Integer> entry : this.myTargetIds.entrySet()) {
                    IOUtil.writeString((String)entry.getKey().getId(), (DataOutput)output);
                    output.writeInt(entry.getValue());
                }
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            LOG.info("Cannot save " + this.myTargetType.getTypeId() + " targets data: " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized int getTargetId(BuildTarget<?> target) {
        if (!this.myTargetIds.containsKey(target)) {
            this.myTargetIds.put(target, this.myTargetsState.getFreeId());
        }
        return this.myTargetIds.get(target);
    }

    public BuildTargetConfiguration getConfiguration(BuildTarget<?> target) {
        BuildTargetConfiguration configuration = (BuildTargetConfiguration)this.myConfigurations.get(target);
        if (configuration == null) {
            configuration = new BuildTargetConfiguration(target, this.myTargetsState);
            this.myConfigurations.putIfAbsent(target, configuration);
            configuration = (BuildTargetConfiguration)this.myConfigurations.get(target);
        }
        return configuration;
    }
}

