/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.utils.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class ClientCellRenderer
extends ColoredListCellRenderer {
    @NotNull
    private final String myEmptyText;

    public ClientCellRenderer() {
        this("");
    }

    public ClientCellRenderer(@NotNull String emptyText) {
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/android/tools/idea/ddms/ClientCellRenderer", "<init>"));
        }
        this.myEmptyText = emptyText;
    }

    static Pair<String, String> splitApplicationName(String name) {
        int index = name.lastIndexOf(46);
        return Pair.of((Object)name.substring(0, index + 1), (Object)name.substring(index + 1));
    }

    private static void renderClient(@NotNull Client c, ColoredTextContainer container) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/ClientCellRenderer", "renderClient"));
        }
        ClientData cd = c.getClientData();
        String name = cd.getClientDescription();
        if (name == null) {
            return;
        }
        Pair<String, String> app = ClientCellRenderer.splitApplicationName(name);
        container.append((String)app.getFirst(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        container.append((String)app.getSecond(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (cd.isValidUserId() && cd.getUserId() != 0) {
            container.append(String.format(" (user %1$d)", cd.getUserId()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        container.append(String.format(" (%1$d)", cd.getPid()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (!c.isValid()) {
            container.append(" [DEAD]", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (value instanceof Client) {
            ClientCellRenderer.renderClient((Client)value, (ColoredTextContainer)this);
        } else if (value == null) {
            this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static class ClientComparator
    implements Comparator<Client> {
        @Override
        public int compare(Client a, Client b) {
            ClientData ad = a.getClientData();
            ClientData bd = b.getClientData();
            String as = ad.getClientDescription() != null ? ad.getClientDescription() : String.valueOf(ad.getPid());
            String bs = bd.getClientDescription() != null ? bd.getClientDescription() : String.valueOf(bd.getPid());
            return as.compareTo(bs);
        }
    }
}

