/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.controllers.GfxController;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageFetcher;
import com.android.tools.idea.editors.gfxtrace.rpc.RenderSettings;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameBufferController
implements GfxController {
    @NotNull
    private final GfxTraceEditor myEditor;
    @NotNull
    private final JBRunnerTabs myBufferTabs;
    @NotNull
    private final JBScrollPane[] myBufferScrollPanes;
    @NotNull
    private AtomicLong myCurrentFetchAtomId;
    @Nullable
    private ImageFetcher myImageFetcher;
    @NotNull
    private JBLoadingPanel[] myLoadingPanels;

    public FrameBufferController(@NotNull GfxTraceEditor editor, @NotNull JBRunnerTabs bufferTabs, @NotNull JBScrollPane colorScrollPane, @NotNull JBScrollPane wireframePane, @NotNull JBScrollPane depthScrollPane) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "<init>"));
        }
        if (bufferTabs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bufferTabs", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "<init>"));
        }
        if (colorScrollPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorScrollPane", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "<init>"));
        }
        if (wireframePane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wireframePane", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "<init>"));
        }
        if (depthScrollPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depthScrollPane", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "<init>"));
        }
        this.myCurrentFetchAtomId = new AtomicLong();
        this.myLoadingPanels = new JBLoadingPanel[BufferType.length];
        this.myEditor = editor;
        this.myBufferTabs = bufferTabs;
        this.myBufferScrollPanes = new JBScrollPane[]{colorScrollPane, wireframePane, depthScrollPane};
        assert (this.myBufferScrollPanes.length == BufferType.length);
        for (int i = 0; i < this.myBufferScrollPanes.length; ++i) {
            this.myBufferScrollPanes[i].getVerticalScrollBar().setUnitIncrement(20);
            this.myBufferScrollPanes[i].getHorizontalScrollBar().setUnitIncrement(20);
            this.myBufferScrollPanes[i].setBorder(BorderFactory.createLineBorder(JBColor.border()));
            this.myLoadingPanels[i] = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this.myEditor.getProject());
            this.myBufferScrollPanes[i].setViewportView((Component)this.myLoadingPanels[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static FetchedImage fetchImage(long atomId, @NotNull ImageFetcher imageFetcher, @NotNull BufferType instance, @Nullable RenderSettings renderSettings) {
        ImageFetcher.ImageFetchHandle imageFetchHandle;
        void renderSettings2;
        if (imageFetcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageFetcher", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "fetchImage"));
        }
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "fetchImage"));
        }
        assert (instance == BufferType.DEPTH_BUFFER || renderSettings2 != null);
        if (renderSettings2 != null) {
            renderSettings2.setWireframe(instance == BufferType.WIREFRAME_BUFFER);
        }
        ImageFetcher.ImageFetchHandle imageFetchHandle2 = imageFetchHandle = instance == BufferType.DEPTH_BUFFER ? imageFetcher.queueDepthImage(atomId) : imageFetcher.queueColorImage(atomId, (RenderSettings)renderSettings2);
        if (imageFetchHandle == null) {
            return null;
        }
        return imageFetcher.resolveImage(imageFetchHandle);
    }

    @Override
    public void startLoad() {
    }

    @Override
    public void commitData(@NotNull GfxController.GfxContextChangeState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "commitData"));
        }
        this.myImageFetcher = new ImageFetcher(this.myEditor.getClient());
        assert (this.myEditor.getCaptureId() != null);
        if (this.myEditor.getDeviceId() == null || this.myEditor.getContext() == null) {
            return;
        }
        this.myImageFetcher.prepareFetch(this.myEditor.getDeviceId(), this.myEditor.getCaptureId(), this.myEditor.getContext());
    }

    public void setImageForId(final long atomId) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myEditor.getCaptureId() != null);
        assert (this.myImageFetcher != null);
        if (this.myCurrentFetchAtomId.get() == atomId) {
            return;
        }
        this.clearCache();
        final ArrayList<BufferType> bufferOrder = new ArrayList<BufferType>(Arrays.asList(BufferType.COLOR_BUFFER, BufferType.WIREFRAME_BUFFER, BufferType.DEPTH_BUFFER));
        for (JBLoadingPanel panel : this.myLoadingPanels) {
            if (panel.isLoading()) continue;
            panel.startLoading();
        }
        this.myCurrentFetchAtomId.set(atomId);
        final ImageFetcher imageFetcher = this.myImageFetcher;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                RenderSettings renderSettings = new RenderSettings();
                renderSettings.setMaxWidth(4096);
                renderSettings.setMaxHeight(4096);
                if (FrameBufferController.this.myBufferTabs.getSelectedInfo() != null) {
                    String tabName = FrameBufferController.this.myBufferTabs.getSelectedInfo().getText();
                    for (BufferType buffer : BufferType.values()) {
                        if (!buffer.getName().equals(tabName)) continue;
                        if (!bufferOrder.remove((Object)buffer)) break;
                        bufferOrder.add(0, buffer);
                        break;
                    }
                }
                for (BufferType buffer : bufferOrder) {
                    if (atomId != FrameBufferController.this.myCurrentFetchAtomId.get()) {
                        return;
                    }
                    FetchedImage fetchedImage = FrameBufferController.fetchImage(atomId, imageFetcher, buffer, renderSettings);
                    if (fetchedImage == null) break;
                    FrameBufferController.this.setIcons(atomId, fetchedImage.createImageIcon(), buffer);
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (atomId == FrameBufferController.this.myCurrentFetchAtomId.get()) {
                            FrameBufferController.this.stopLoading();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void clear() {
        this.myImageFetcher = null;
        this.stopLoading();
        this.clearCache();
    }

    @Override
    public void clearCache() {
        for (JBLoadingPanel panel : this.myLoadingPanels) {
            panel.getContentPanel().removeAll();
        }
        this.myCurrentFetchAtomId.set(-1L);
    }

    private void stopLoading() {
        for (JBLoadingPanel panel : this.myLoadingPanels) {
            if (!panel.isLoading()) continue;
            panel.stopLoading();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setIcons(final long closedAtomId, @NotNull ImageIcon image, @NotNull BufferType bufferType) {
        void bufferType2;
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "setIcons"));
        }
        if (bufferType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bufferType", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "setIcons"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable((BufferType)bufferType2, image){
            final /* synthetic */ BufferType val$bufferType;
            final /* synthetic */ ImageIcon val$image;
            {
                this.val$bufferType = bufferType;
                this.val$image = imageIcon;
            }

            @Override
            public void run() {
                if (FrameBufferController.this.myCurrentFetchAtomId.get() == closedAtomId) {
                    int index = this.val$bufferType.ordinal();
                    FrameBufferController.this.myLoadingPanels[index].add((Component)new JBLabel((Icon)this.val$image));
                    if (FrameBufferController.this.myLoadingPanels[index].isLoading()) {
                        FrameBufferController.this.myLoadingPanels[index].stopLoading();
                    }
                    FrameBufferController.this.myBufferScrollPanes[index].repaint();
                }
            }
        });
    }

    public static enum BufferType {
        COLOR_BUFFER("Color"),
        WIREFRAME_BUFFER("Wirefame"),
        DEPTH_BUFFER("Depth");

        private static final int length;
        @NotNull
        private final String myName;

        private BufferType(String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController$BufferType", "<init>"));
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController$BufferType", "getName"));
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController$BufferType", "toString"));
            }
            return string;
        }

        static {
            length = BufferType.values().length;
        }
    }
}

