/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import java.awt.Component;
import java.awt.Font;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import spantable.CellSpanModel;

public class DelegatingCellEditor
implements TableCellEditor {
    private final TableCellEditor myDelegate;
    private final boolean myConvertValueToString;
    private final ThemeEditorContext myContext;

    public DelegatingCellEditor(boolean convertValueToString, TableCellEditor delegate, @NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/DelegatingCellEditor", "<init>"));
        }
        this.myConvertValueToString = convertValueToString;
        this.myDelegate = delegate;
        this.myContext = context;
    }

    public DelegatingCellEditor(TableCellEditor delegate, @NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/DelegatingCellEditor", "<init>"));
        }
        this(true, delegate, context);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Font font;
        Object stringValue;
        String tooltipText;
        CellSpanModel model = (CellSpanModel)table.getModel();
        if (value instanceof EditedStyleItem) {
            EditedStyleItem item = (EditedStyleItem)value;
            tooltipText = ThemeEditorUtils.generateToolTipText(item.getItemResourceValue(), this.myContext.getCurrentThemeModule(), this.myContext.getConfiguration());
            stringValue = ThemeEditorUtils.extractRealValue(item, model.getCellClass(row, column));
            ThemeEditorStyle selectedStyle = ((AttributesTableModel)table.getModel()).getSelectedStyle();
            font = selectedStyle.hasItem(item) ? table.getFont().deriveFont(1) : table.getFont();
        } else {
            stringValue = value;
            tooltipText = null;
            font = table.getFont();
        }
        Component returnedComponent = this.myDelegate.getTableCellEditorComponent(table, this.myConvertValueToString ? stringValue : value, isSelected, row, column);
        returnedComponent.setFont(font);
        if (returnedComponent instanceof JComponent) {
            JComponent jComponent = (JComponent)returnedComponent;
            jComponent.setToolTipText(tooltipText);
            jComponent.setComponentPopupMenu(table.getComponentPopupMenu());
        }
        return returnedComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.myDelegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.myDelegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.myDelegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.myDelegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.myDelegate.cancelCellEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.myDelegate.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.myDelegate.removeCellEditorListener(l);
    }
}

