/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.dependency.Dependency;
import com.android.tools.idea.gradle.dependency.DependencySet;
import com.android.tools.idea.gradle.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.dependency.LibraryDependency;
import com.android.tools.idea.gradle.dependency.ModuleDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.base.Objects;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<IdeaAndroidProject>
implements BuildVariantModuleCustomizer<IdeaAndroidProject> {
    @Override
    protected void setUpDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull IdeaAndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        DependencySet dependencies = Dependency.extractFrom(androidProject);
        for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
            DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, libraryDependency, androidProject.getDelegate());
        }
        for (ModuleDependency moduleDependency : dependencies.onModules()) {
            this.updateModuleDependency(module, modelsProvider, moduleDependency, androidProject.getDelegate());
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(module.getProject());
        Collection<SyncIssue> collection = androidProject.getSyncIssues();
        if (collection != null) {
            messages.reportSyncIssues(collection, module);
        } else {
            Collection unresolvedDependencies = androidProject.getDelegate().getUnresolvedDependencies();
            messages.reportUnresolvedDependencies(unresolvedDependencies, module);
        }
    }

    private void updateModuleDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        Module moduleDependency = null;
        for (Module m : modelsProvider.getModules()) {
            String gradlePath;
            AndroidGradleFacet androidGradleFacet = AndroidGradleFacet.getInstance(m);
            if (androidGradleFacet == null || !Objects.equal((Object)(gradlePath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH), (Object)dependency.getGradlePath())) continue;
            moduleDependency = m;
            break;
        }
        LibraryDependency compiledArtifact = dependency.getBackupDependency();
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addModuleOrderEntry(moduleDependency);
            orderEntry.setExported(true);
            if (compiledArtifact != null) {
                Projects.setModuleCompiledArtifact(moduleDependency, compiledArtifact);
            }
            return;
        }
        String backupName = compiledArtifact != null ? compiledArtifact.getName() : null;
        DependencySetupErrors setupErrors = this.getSetupErrors(module.getProject());
        setupErrors.addMissingModule(dependency.getGradlePath(), module.getName(), backupName);
        if (compiledArtifact != null) {
            DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, compiledArtifact, androidProject);
        }
    }

    public static void updateLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        Collection<String> binaryPaths = dependency.getPaths(LibraryDependency.PathType.BINARY);
        DependenciesModuleCustomizer.setUpLibraryDependency(module, modelsProvider, dependency.getName(), dependency.getScope(), binaryPaths);
        File buildFolder = androidProject.getBuildFolder();
        ContentEntry[] contentEntries = modelsProvider.getModifiableRootModel(module).getContentEntries();
        for (String binaryPath : binaryPaths) {
            ContentEntry parentContentEntry;
            File parent = new File(binaryPath).getParentFile();
            if (parent == null || !"jars".equals(parent.getName()) || !FileUtil.isAncestor((File)buildFolder, (File)parent, (boolean)true) || (parentContentEntry = FilePaths.findParentContentEntry(parent, contentEntries)) == null) continue;
            parentContentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(parent));
        }
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public Class<IdeaAndroidProject> getSupportedModelType() {
        if (IdeaAndroidProject.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "getSupportedModelType"));
        }
        return IdeaAndroidProject.class;
    }
}

