/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaGradleProject;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetType;
import com.android.tools.idea.gradle.util.Facets;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Maps;
import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectDataService
extends AbstractProjectDataService<IdeaGradleProject, Void> {
    private static final Logger LOG = Logger.getInstance(GradleProjectDataService.class);

    @NotNull
    public Key<IdeaGradleProject> getTargetDataKey() {
        Key<IdeaGradleProject> key = AndroidProjectKeys.IDE_GRADLE_PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<IdeaGradleProject>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/GradleProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/GradleProjectDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/service/GradleProjectDataService", "importData"));
        }
        if (!toImport.isEmpty()) {
            try {
                GradleProjectDataService.doImport(toImport, project, modelsProvider);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up modules in project '%1$s'", project.getName()), e);
                GradleSyncState.getInstance(project).syncFailed(e.getMessage());
            }
        }
    }

    private static void doImport(final @NotNull Collection<DataNode<IdeaGradleProject>> toImport, final @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) throws Throwable {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/GradleProjectDataService", "doImport"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/GradleProjectDataService", "doImport"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/service/GradleProjectDataService", "doImport"));
        }
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                if (!project.isDisposed()) {
                    Map gradleProjectsByName = GradleProjectDataService.indexByModuleName(toImport);
                    for (Module module : modelsProvider.getModules()) {
                        IdeaGradleProject gradleProject = (IdeaGradleProject)gradleProjectsByName.get(module.getName());
                        if (gradleProject == null) {
                            Facets.removeAllFacetsOfType(AndroidGradleFacet.TYPE_ID, modelsProvider.getModifiableFacetModel(module));
                            continue;
                        }
                        String gradleVersion = gradleProject.getGradleVersion();
                        if (StringUtil.isNotEmpty((String)gradleVersion)) {
                            Projects.setGradleVersionUsed(project, gradleVersion);
                        }
                        GradleProjectDataService.customizeModule(module, gradleProject, modelsProvider);
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    @NotNull
    private static Map<String, IdeaGradleProject> indexByModuleName(@NotNull Collection<DataNode<IdeaGradleProject>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/android/tools/idea/gradle/service/GradleProjectDataService", "indexByModuleName"));
        }
        HashMap gradleProjectsByModuleName = Maps.newHashMap();
        for (DataNode<IdeaGradleProject> d : dataNodes) {
            IdeaGradleProject gradleProject = (IdeaGradleProject)d.getData();
            gradleProjectsByModuleName.put(gradleProject.getModuleName(), gradleProject);
        }
        HashMap hashMap = gradleProjectsByModuleName;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "indexByModuleName"));
        }
        return hashMap;
    }

    private static void customizeModule(@NotNull Module module, @NotNull IdeaGradleProject gradleProject, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/GradleProjectDataService", "customizeModule"));
        }
        if (gradleProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProject", "com/android/tools/idea/gradle/service/GradleProjectDataService", "customizeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/service/GradleProjectDataService", "customizeModule"));
        }
        AndroidGradleFacet androidGradleFacet = GradleProjectDataService.setAndGetAndroidGradleFacet(module, modelsProvider);
        androidGradleFacet.setGradleProject(gradleProject);
    }

    @NotNull
    private static AndroidGradleFacet setAndGetAndroidGradleFacet(Module module, IdeModifiableModelsProvider modelsProvider) {
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        if (facet != null) {
            AndroidGradleFacet androidGradleFacet = facet;
            if (androidGradleFacet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "setAndGetAndroidGradleFacet"));
            }
            return androidGradleFacet;
        }
        ModifiableFacetModel model = modelsProvider.getModifiableFacetModel(module);
        AndroidGradleFacetType facetType = AndroidGradleFacet.getFacetType();
        facet = facetType.createFacet(module, "Android-Gradle", facetType.createDefaultConfiguration(), (Facet)null);
        model.addFacet((Facet)facet);
        AndroidGradleFacet androidGradleFacet = facet;
        if (androidGradleFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/GradleProjectDataService", "setAndGetAndroidGradleFacet"));
        }
        return androidGradleFacet;
    }
}

