/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.LineMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ASGallery<E>
extends JComponent
implements Accessible,
Scrollable {
    private static final Insets DEFAULT_CELL_MARGIN = new Insets(1, 1, 1, 1);
    @NotNull
    private Insets myCellMargin;
    private static final int INCSEARCH_TIMEOUT_MS = 500;
    private final EventListenerList myListeners;
    private final ListDataListener myListDataListener;
    @NotNull
    private Dimension myThumbnailSize;
    private int mySelectedIndex;
    private ListModel myModel;
    private String myFilterString;
    private long myPreviousKeypressTimestamp;
    @NotNull
    private LoadingCache<E, Optional<Image>> myImagesCache;
    @NotNull
    private Function<? super E, String> myLabelProvider;

    public ASGallery() {
        this(new DefaultListModel(), Functions.constant(null), Functions.toStringFunction(), new Dimension(0, 0));
    }

    public ASGallery(@NotNull ListModel model, @NotNull Function<? super E, Image> imageProvider, @NotNull Function<? super E, String> labelProvider, @NotNull Dimension thumbnailSize) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/wizard/ASGallery", "<init>"));
        }
        if (imageProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageProvider", "com/android/tools/idea/wizard/ASGallery", "<init>"));
        }
        if (labelProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelProvider", "com/android/tools/idea/wizard/ASGallery", "<init>"));
        }
        if (thumbnailSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thumbnailSize", "com/android/tools/idea/wizard/ASGallery", "<init>"));
        }
        this.myCellMargin = DEFAULT_CELL_MARGIN;
        this.myListeners = new EventListenerList();
        this.myListDataListener = new InternalListDataListener();
        this.myThumbnailSize = new Dimension(128, 128);
        this.mySelectedIndex = -1;
        this.myFilterString = "";
        this.myPreviousKeypressTimestamp = 0L;
        this.myLabelProvider = Functions.toStringFunction();
        Font listFont = UIUtil.getListFont();
        if (listFont != null) {
            this.setFont(listFont);
        }
        this.setThumbnailSize(thumbnailSize);
        this.setImageProvider(imageProvider);
        this.setLabelProvider(labelProvider);
        this.setModel(model);
        this.setOpaque(true);
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ASGallery.this.requestFocusInWindow();
                int cell = ASGallery.this.getCellAt(e.getPoint());
                if (cell >= 0) {
                    ASGallery.this.setSelectedIndex(cell);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ASGallery.this.reveal();
                ASGallery.this.updateFocusRectangle();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ASGallery.this.updateFocusRectangle();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (keyChar != '\uffff') {
                    ASGallery.this.incrementalSearch(keyChar);
                }
            }
        });
        this.setBackground(UIUtil.getListBackground());
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        ImmutableMap keysToActions = ImmutableMap.builder().put((Object)40, (Object)new MoveSelectionAction(1, 0)).put((Object)38, (Object)new MoveSelectionAction(-1, 0)).put((Object)37, (Object)new MoveSelectionAction(0, -1)).put((Object)39, (Object)new MoveSelectionAction(0, 1)).put((Object)36, (Object)new JumpSelection(){

            @Override
            public int getIndex() {
                return 0;
            }
        }).put((Object)35, (Object)new JumpSelection(){

            @Override
            public int getIndex() {
                return ASGallery.this.myModel.getSize() - 1;
            }
        }).build();
        for (Map.Entry entry : keysToActions.entrySet()) {
            String key = "selection_move_" + entry.getKey();
            inputMap.put(KeyStroke.getKeyStroke((Integer)entry.getKey(), 0), key);
            actionMap.put(key, (Action)entry.getValue());
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = new Dimension(this.computeCellSize());
        Insets insets = this.getInsets();
        size.setSize(size.getWidth() + (double)insets.left + (double)insets.right, size.getHeight() + (double)insets.top + (double)insets.bottom);
        return this.computeCellSize();
    }

    private static int intDivideRoundUp(int divident, int divisor) {
        return (divident + divisor - 1) / divisor;
    }

    private static int getElementIndex(@NotNull ListModel model, @Nullable Object element) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/wizard/ASGallery", "getElementIndex"));
        }
        if (element == null) {
            return -1;
        }
        for (int i = 0; i < model.getSize(); ++i) {
            Object modelElement = model.getElementAt(i);
            if (!Objects.equal((Object)element, modelElement)) continue;
            return i;
        }
        return -1;
    }

    public void setLabelProvider(@NotNull Function<? super E, String> labelProvider) {
        if (labelProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelProvider", "com/android/tools/idea/wizard/ASGallery", "setLabelProvider"));
        }
        this.myLabelProvider = labelProvider;
        this.repaint(this.getVisibleRect());
    }

    public void setThumbnailSize(@NotNull Dimension thumbnailSize) {
        if (thumbnailSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thumbnailSize", "com/android/tools/idea/wizard/ASGallery", "setThumbnailSize"));
        }
        if (!Objects.equal((Object)thumbnailSize, (Object)this.myThumbnailSize)) {
            this.myThumbnailSize = thumbnailSize;
            this.invalidate();
            this.repaint(this.getVisibleRect());
        }
    }

    public void setImageProvider(@NotNull Function<? super E, Image> imageProvider) {
        if (imageProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageProvider", "com/android/tools/idea/wizard/ASGallery", "setImageProvider"));
        }
        CacheLoader cacheLoader = CacheLoader.from(ToOptionalFunction.wrap(imageProvider));
        this.myImagesCache = CacheBuilder.newBuilder().weakKeys().build(cacheLoader);
        this.repaint(this.getVisibleRect());
    }

    private void incrementalSearch(char keyChar) {
        long timestamp = System.currentTimeMillis();
        this.myFilterString = timestamp - this.myPreviousKeypressTimestamp > 500L ? String.valueOf(keyChar) : this.myFilterString + keyChar;
        int ind = this.findMatchingItem();
        this.myPreviousKeypressTimestamp = timestamp;
        if (ind < 0) {
            boolean resumedSearch = this.myFilterString.length() > 1;
            this.myFilterString = "";
            if (resumedSearch) {
                this.incrementalSearch(keyChar);
            }
        } else {
            this.setSelectedIndex(ind);
        }
    }

    private int findMatchingItem() {
        int itemCount = this.myModel.getSize();
        int startingIndex = Math.max(0, this.mySelectedIndex);
        int secondBest = -1;
        String normalizedFilterString = StringUtil.toLowerCase((String)this.myFilterString);
        for (int i = startingIndex; i < itemCount + startingIndex; ++i) {
            int index = i % itemCount;
            String title = this.getLabel(index);
            if (StringUtil.isEmpty((String)title)) continue;
            String normalizedTitle = StringUtil.toLowerCase((String)title);
            if (normalizedTitle.startsWith(normalizedFilterString)) {
                return index;
            }
            if (secondBest >= 0 || !normalizedTitle.contains(" " + normalizedFilterString)) continue;
            secondBest = index;
        }
        return secondBest;
    }

    @Nullable
    private String getLabel(int index) {
        Object element = this.myModel.getElementAt(index);
        if (element == null) {
            return null;
        }
        return (String)this.myLabelProvider.apply(element);
    }

    protected int getCellAt(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/android/tools/idea/wizard/ASGallery", "getCellAt"));
        }
        Insets borderInsets = this.getInsets();
        int columnCount = this.getColumnCount();
        Dimension cellDimensions = this.computeCellSize();
        int galleryWidth = this.getClientWidth(borderInsets);
        int offsetX = point.x - borderInsets.left;
        int offsetY = point.y - borderInsets.top;
        if (offsetX >= galleryWidth || offsetX < 0) {
            return -1;
        }
        int column = 0;
        while (this.getColumnOffset(column + 1, columnCount, galleryWidth) <= offsetX) {
            ++column;
        }
        int row = offsetY / cellDimensions.height;
        if (row < 0 || row > this.myModel.getSize() / columnCount) {
            return -1;
        }
        int selection = column + row * columnCount;
        return selection >= 0 && selection < this.myModel.getSize() ? selection : -1;
    }

    private int getClientWidth(Insets borderInsets) {
        return this.getWidth() - borderInsets.left - borderInsets.right;
    }

    private int getNewSelectionIndex(int vdirection, int hdirection) {
        if (this.mySelectedIndex < 0) {
            return 0;
        }
        int columnCount = this.getColumnCount();
        int column = this.mySelectedIndex % columnCount + hdirection;
        int row = this.mySelectedIndex / columnCount + vdirection;
        if (column >= 0 && column < columnCount) {
            int newSelection = column + row * columnCount;
            if (newSelection < 0) {
                return 0;
            }
            int itemCount = this.myModel.getSize();
            if (newSelection >= itemCount) {
                return itemCount - 1;
            }
            return newSelection;
        }
        return this.mySelectedIndex;
    }

    private void updateFocusRectangle() {
        if (this.mySelectedIndex >= 0) {
            this.repaint(this.getVisibleRect());
        }
    }

    @NotNull
    public Insets getCellMargin() {
        Insets insets = this.myCellMargin;
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ASGallery", "getCellMargin"));
        }
        return insets;
    }

    public void setCellMargin(@Nullable Insets cellMargin) {
        Insets insets = cellMargin = cellMargin == null ? DEFAULT_CELL_MARGIN : cellMargin;
        if (!Objects.equal((Object)cellMargin, (Object)this.myCellMargin)) {
            Insets oldInsets = this.myCellMargin;
            this.myCellMargin = cellMargin;
            this.firePropertyChange("cellMargin", oldInsets, cellMargin);
        }
    }

    @Nullable
    public E getSelectedElement() {
        if (this.mySelectedIndex < 0) {
            return null;
        }
        return this.myModel.getElementAt(this.mySelectedIndex);
    }

    public void setSelectedElement(@Nullable E element) {
        int index;
        if (element == null) {
            index = -1;
        } else {
            index = ASGallery.getElementIndex(this.getModel(), element);
            if (index < 0) {
                throw new NoSuchElementException(element.toString());
            }
        }
        this.setSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.setSelectedIndex(selectedIndex, true);
    }

    private void setSelectedIndex(int selectedIndex, boolean notifyListeners) {
        assert (selectedIndex < this.myModel.getSize() && selectedIndex >= -1);
        if (selectedIndex != this.mySelectedIndex) {
            this.mySelectedIndex = selectedIndex;
            this.repaint(this.getVisibleRect());
            this.revealCell(this.mySelectedIndex);
            if (notifyListeners) {
                this.fireSelectionChanged(this.mySelectedIndex);
            }
        }
    }

    private void fireSelectionChanged(int newSelection) {
        boolean isSelectionListener = false;
        ListSelectionEvent event = new ListSelectionEvent(this, newSelection, newSelection, false);
        for (Object object : this.myListeners.getListenerList()) {
            if (isSelectionListener) {
                ((ListSelectionListener)object).valueChanged(event);
                isSelectionListener = false;
                continue;
            }
            isSelectionListener = object == ListSelectionListener.class;
        }
    }

    @NotNull
    public ListModel getModel() {
        ListModel listModel = this.myModel;
        if (listModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ASGallery", "getModel"));
        }
        return listModel;
    }

    public void setModel(@NotNull ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/wizard/ASGallery", "setModel"));
        }
        if (!Objects.equal((Object)this.myModel, (Object)model)) {
            Object element;
            if (this.myModel != null) {
                this.myModel.removeListDataListener(this.myListDataListener);
                element = this.mySelectedIndex < 0 ? null : this.myModel.getElementAt(this.mySelectedIndex);
            } else {
                element = null;
            }
            this.myModel = model;
            this.myModel.addListDataListener(this.myListDataListener);
            this.invalidate();
            this.setSelectedIndex(ASGallery.getElementIndex(this.myModel, element));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int itemCount;
        Dimension preferredSize = super.getPreferredSize();
        int n = itemCount = this.myModel == null ? 0 : this.myModel.getSize();
        if (this.isPreferredSizeSet() || itemCount == 0) {
            return preferredSize;
        }
        Insets insets = this.getInsets();
        int insetsWidth = insets.left + insets.right;
        int insetsHeight = insets.top + insets.bottom;
        Dimension cellSize = this.computeCellSize();
        int width = this.getWidth();
        if (width == 0) {
            return new Dimension(cellSize.width + insetsWidth, cellSize.height + insetsHeight);
        }
        int rows = ASGallery.intDivideRoundUp(itemCount, this.getColumnCount());
        int height = rows * cellSize.height + insetsHeight;
        return new Dimension(Math.max(width, cellSize.width + insetsWidth), height);
    }

    protected int getColumnCount() {
        int entries;
        Dimension cellSize = this.computeCellSize();
        int width = this.getClientWidth(this.getInsets());
        int columnCount = Math.max(width / cellSize.width, 1);
        if (this.myModel != null && columnCount > (entries = this.myModel.getSize()) && columnCount < entries * 2) {
            return entries;
        }
        return columnCount;
    }

    protected Dimension computeCellSize() {
        Dimension imageSize = this.myThumbnailSize;
        int width = imageSize.width + this.myCellMargin.left + this.myCellMargin.right;
        int textHeight = this.getFont().getSize();
        int height = imageSize.height + this.myCellMargin.top + this.myCellMargin.bottom + 2 * textHeight;
        return new Dimension(width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle clipRectangle = g.getClipBounds();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(clipRectangle.x, clipRectangle.y, clipRectangle.width, clipRectangle.height);
        }
        Dimension cellBounds = this.computeCellSize();
        int firstColumn = clipRectangle.x / cellBounds.width;
        int lastColumn = (clipRectangle.x + clipRectangle.width) / cellBounds.width;
        int firstRow = clipRectangle.y / cellBounds.height;
        int lastRow = ASGallery.intDivideRoundUp(clipRectangle.y + clipRectangle.height, cellBounds.height);
        Insets borderInsets = this.getInsets();
        int componentWidth = this.getClientWidth(borderInsets);
        int columns = this.getColumnCount();
        for (int row = firstRow; row <= lastRow; ++row) {
            int cell;
            for (int column = firstColumn; column <= lastColumn && (cell = row * columns + column) < this.myModel.getSize(); ++column) {
                int cellX = this.getColumnOffset(column, columns, componentWidth);
                int width = this.getColumnOffset(column + 1, columns, componentWidth) - cellX;
                int cellY = row * cellBounds.height + borderInsets.top;
                int cellHeight = cellBounds.height - 1;
                Rectangle bounds = new Rectangle(cellX + borderInsets.left, cellY, width, cellHeight);
                this.paintCell(g, cell, bounds);
            }
        }
    }

    private void paintCell(Graphics g, int cell, Rectangle cellBounds) {
        int thumbnailHeight;
        String label = this.getLabel(cell);
        Image thumbnail = this.getImage(cell);
        this.drawSelection(g, cell, cellBounds, !StringUtil.isEmpty((String)label) && thumbnail != null);
        if (thumbnail != null) {
            Dimension thumbnailSize = this.myThumbnailSize;
            int imageX = cellBounds.x + (cellBounds.width - thumbnailSize.width) / 2;
            int imageY = cellBounds.y + this.myCellMargin.top;
            g.drawImage(thumbnail, imageX, imageY, thumbnailSize.width, thumbnailSize.height, null);
            thumbnailHeight = thumbnailSize.height;
        } else {
            thumbnailHeight = 0;
        }
        this.paintLabel(g, cell, cellBounds, label, thumbnailHeight);
    }

    private void paintLabel(Graphics g, int cell, Rectangle cellBounds, @Nullable String label, int thumbnailHeight) {
        if (!StringUtil.isEmpty((String)label)) {
            Color fg = this.hasFocus() && cell == this.mySelectedIndex && (this.getImage(cell) != null || UIUtil.isUnderDarcula()) ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
            GraphicsUtil.setupAntialiasing((Graphics)g);
            g.setColor(fg);
            FontMetrics fontMetrics = g.getFontMetrics();
            LineMetrics metrics = fontMetrics.getLineMetrics(label, g);
            int width = fontMetrics.stringWidth(label);
            int textBoxTop = this.myCellMargin.top + thumbnailHeight;
            int cellBottom = cellBounds.height - this.myCellMargin.bottom;
            int textY = cellBounds.y + (cellBottom + textBoxTop + (int)(metrics.getHeight() - metrics.getDescent())) / 2;
            int textX = (cellBounds.width - this.myCellMargin.left - this.myCellMargin.right - width) / 2 + cellBounds.x + this.myCellMargin.left;
            g.drawString(label, textX, textY);
        }
    }

    private void drawSelection(Graphics g, int cell, Rectangle cellBounds, boolean paintLabelBackground) {
        if (cell == this.mySelectedIndex) {
            Color currentColor = g.getColor();
            Color bg = UIUtil.getTreeSelectionBackground((boolean)this.hasFocus());
            g.setColor(bg);
            g.drawRect(cellBounds.x, cellBounds.y, cellBounds.width - 1, cellBounds.height - 1);
            if (paintLabelBackground) {
                int textBoxTop = this.myThumbnailSize.height + this.myCellMargin.top;
                g.fillRect(cellBounds.x, cellBounds.y + textBoxTop, cellBounds.width - 1, cellBounds.height - textBoxTop);
            }
            if (this.hasFocus()) {
                Border border = UIUtil.getTableFocusCellHighlightBorder();
                border.paintBorder(this, g, cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
            }
            g.setColor(currentColor);
        }
    }

    @Nullable
    private Image getImage(int cell) {
        Object elementAt = this.myModel.getElementAt(cell);
        if (elementAt == null) {
            return null;
        }
        try {
            Optional image = (Optional)this.myImagesCache.get(elementAt);
            return (Image)image.orNull();
        }
        catch (ExecutionException e) {
            Logger.getInstance(this.getClass()).error((Throwable)e);
            return null;
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.computeCellSize().height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.myListeners.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.myListeners.remove(ListSelectionListener.class, listener);
    }

    private void reveal() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex > 0) {
            this.revealCell(selectedIndex);
        }
    }

    private void revealCell(int selectedIndex) {
        int columnCount = this.getColumnCount();
        Insets borderInsets = this.getInsets();
        int width = this.getClientWidth(borderInsets);
        int height = this.computeCellSize().height;
        int column = selectedIndex % columnCount;
        int x = this.getColumnOffset(column, columnCount, width) + borderInsets.left;
        int y = selectedIndex / columnCount * height + borderInsets.top;
        this.scrollRectToVisible(new Rectangle(x, y, width, height));
    }

    protected int getColumnOffset(int column, int columnCount, int galleryWidth) {
        if (columnCount <= this.myModel.getSize()) {
            return column * galleryWidth / columnCount;
        }
        return column * this.computeCellSize().width;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleASGallery();
        }
        return this.accessibleContext;
    }

    private final class AccessibleCell
    extends JComponent.AccessibleJComponent
    implements Accessible,
    AccessibleComponent,
    AccessibleAction {
        private final int myIndex;

        public AccessibleCell(int index) {
            super(ASGallery.this);
            this.myIndex = index;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleState[] state = new AccessibleState[]{AccessibleState.SELECTABLE, AccessibleState.SINGLE_LINE, AccessibleState.ACTIVE};
            return new AccessibleStateSet(state);
        }

        @Override
        public Accessible getAccessibleParent() {
            return ASGallery.this;
        }

        @Override
        public String getAccessibleName() {
            String label = ASGallery.this.getLabel(this.myIndex);
            return StringUtil.isEmpty((String)label) ? "No Label" : label;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return this.myIndex;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            return AccessibleAction.CLICK;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            ASGallery.this.setSelectedIndex(this.myIndex);
            return true;
        }
    }

    private final class AccessibleASGallery
    extends JComponent.AccessibleJComponent
    implements PropertyChangeListener,
    ListSelectionListener {
        private Map<Integer, Accessible> children;

        public AccessibleASGallery() {
            super(ASGallery.this);
            this.children = Maps.newHashMap();
            this.setAccessibleName(ASGallery.this.getName());
            ASGallery.this.addPropertyChangeListener(this);
            ASGallery.this.addListSelectionListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("name".equals(evt.getPropertyName())) {
                this.setAccessibleName((String)evt.getNewValue());
            } else if ("model".equals(evt.getPropertyName())) {
                this.firePropertyChange("accessibleInvalidateChildren", null, ASGallery.this);
            }
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ASGallery.this.getModel().getSize();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (!this.children.containsKey(i)) {
                this.children.put(i, new AccessibleCell(i));
            }
            return this.children.get(i);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.firePropertyChange("AccessibleActiveDescendant", false, true);
            this.firePropertyChange("AccessibleSelection", false, true);
        }
    }

    private class InternalListDataListener
    implements ListDataListener {
        private InternalListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (e.getIndex0() <= ASGallery.this.mySelectedIndex) {
                int newSelection = ASGallery.this.mySelectedIndex + e.getIndex1() - e.getIndex0() - 1;
                ASGallery.this.setSelectedIndex(newSelection, false);
            }
            ASGallery.this.invalidate();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            int firstRemoved = e.getIndex0();
            if (firstRemoved <= ASGallery.this.mySelectedIndex) {
                int lastRemoved = e.getIndex1();
                int index = ASGallery.this.mySelectedIndex - (lastRemoved - firstRemoved + 1);
                int newSelectionIndex = Math.min(Math.max(index, e.getIndex0()), ASGallery.this.myModel.getSize() - 1);
                ASGallery.this.setSelectedIndex(newSelectionIndex, ASGallery.this.mySelectedIndex <= lastRemoved);
            }
            ASGallery.this.invalidate();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ASGallery.this.invalidate();
        }
    }

    private abstract class JumpSelection
    extends AbstractAction {
        private JumpSelection() {
        }

        public abstract int getIndex();

        @Override
        public boolean isEnabled() {
            return this.getIndex() >= 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ASGallery.this.setSelectedIndex(this.getIndex());
        }
    }

    private class MoveSelectionAction
    extends AbstractAction {
        private final int myVdirection;
        private final int myHdirection;

        public MoveSelectionAction(int vdirection, int hdirection) {
            this.myVdirection = vdirection;
            this.myHdirection = hdirection;
        }

        @Override
        public boolean isEnabled() {
            return ASGallery.this.getNewSelectionIndex(this.myVdirection, this.myHdirection) != ASGallery.this.mySelectedIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ASGallery.this.setSelectedIndex(ASGallery.this.getNewSelectionIndex(this.myVdirection, this.myHdirection));
        }
    }

    private static final class ToOptionalFunction<P, R>
    implements Function<P, Optional<R>> {
        private final Function<P, R> myFunction;

        public ToOptionalFunction(Function<P, R> function) {
            this.myFunction = function;
        }

        public static <P, R> Function<P, Optional<R>> wrap(Function<P, R> function) {
            return new ToOptionalFunction<P, R>(function);
        }

        public Optional<R> apply(P input) {
            Object result = this.myFunction.apply(input);
            return Optional.fromNullable((Object)result);
        }
    }
}

