/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.builder.model.SourceProvider;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.wizard.AssetStudioAssetGenerator;
import com.android.tools.idea.wizard.ImageComponent;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.google.common.collect.Iterators;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonAssetSetStep
extends TemplateWizardStep
implements Disposable {
    private static final Logger LOG = Logger.getInstance(CommonAssetSetStep.class);
    protected SourceProvider mySourceProvider = null;
    protected AssetStudioAssetGenerator myAssetGenerator;
    protected AssetStudioAssetGenerator.AssetType mySelectedAssetType;
    protected boolean myInitialized;
    protected final MergingUpdateQueue myUpdateQueue;
    protected final Map<String, Map<String, BufferedImage>> myImageMap = new ConcurrentHashMap<String, Map<String, BufferedImage>>();

    public CommonAssetSetStep(TemplateWizardState state, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener, @Nullable VirtualFile invocationTarget) {
        super(state, project, module, sidePanelIcon, updateListener);
        AndroidFacet facet;
        this.myAssetGenerator = new AssetStudioAssetGenerator(state);
        if (invocationTarget != null && module != null && (facet = AndroidFacet.getInstance(this.myModule)) != null) {
            this.mySourceProvider = (SourceProvider)Iterators.getNext(IdeaSourceProvider.getSourceProvidersForFile(facet, invocationTarget, null).iterator(), null);
        }
        this.myUpdateQueue = new MergingUpdateQueue("asset.studio", 200, true, null, (Disposable)this, null, false);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        String assetName = this.myTemplateState.getString("assetName");
        if (this.drawableExists(assetName)) {
            this.setErrorHtml(String.format("A drawable resource named %s already exists and will be overwritten.", assetName));
        }
        this.requestPreviewUpdate();
        return this.isValid();
    }

    private void requestPreviewUpdate() {
        this.myUpdateQueue.cancelAllUpdates();
        this.myUpdateQueue.queue(new Update("update"){

            public void run() {
                try {
                    CommonAssetSetStep.this.myAssetGenerator.generateImages(CommonAssetSetStep.this.myImageMap, true, true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CommonAssetSetStep.this.updatePreviewImages();
                        }
                    });
                }
                catch (AssetStudioAssetGenerator.ImageGeneratorException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CommonAssetSetStep.this.setErrorHtml(e.getMessage());
                        }
                    });
                }
            }
        });
    }

    protected abstract void updatePreviewImages();

    protected static void setIconOrClear(@NotNull ImageComponent component, @Nullable BufferedImage image) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/wizard/CommonAssetSetStep", "setIconOrClear"));
        }
        if (image == null) {
            component.setIcon(null);
        } else {
            component.setIcon(new ImageIcon(image));
        }
    }

    public void updateStep() {
        super.updateStep();
        if (!this.myInitialized) {
            this.myInitialized = true;
            this.initialize();
        }
    }

    protected abstract void initialize();

    @NotNull
    protected abstract String computeResourceName();

    public void createAssets(@Nullable Module module) {
        File targetResDir = (File)this.myTemplateState.get("outputFolder");
        if (targetResDir == null) {
            if (this.myTemplateState.hasAttr("resDir")) {
                assert (module != null);
                File moduleDir = new File(module.getModuleFilePath()).getParentFile();
                targetResDir = new File(moduleDir, this.myTemplateState.getString("resDir"));
            } else {
                return;
            }
        }
        this.generateAssetFiles(targetResDir);
        VirtualFile resDir = LocalFileSystem.getInstance().findFileByIoFile(targetResDir);
        if (resDir != null) {
            resDir.refresh(true, true);
        } else if (this.myProject != null) {
            this.myProject.getBaseDir().refresh(true, true);
        }
    }

    protected abstract void generateAssetFiles(File var1);

    protected boolean drawableExists(String resourceName) {
        if (this.mySourceProvider != null) {
            return Parameter.existsResourceFile(this.mySourceProvider, this.myModule, ResourceFolderType.DRAWABLE, ResourceType.DRAWABLE, resourceName);
        }
        return Parameter.existsResourceFile(this.myModule, ResourceType.DRAWABLE, resourceName);
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }
}

