/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.CachingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFilesStateChangeRule;
import org.gradle.api.internal.changedetection.rules.InputPropertiesStateChangeRule;
import org.gradle.api.internal.changedetection.rules.NoHistoryStateChangeRule;
import org.gradle.api.internal.changedetection.rules.OutputFilesStateChangeRule;
import org.gradle.api.internal.changedetection.rules.SummaryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskTypeStateChangeRule;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;

public class TaskUpToDateState {
    private static final int MAX_OUT_OF_DATE_MESSAGES = 3;
    private final FilesSnapshotSet inputFilesSnapshot;
    private TaskStateChanges noHistoryState;
    private TaskStateChanges inputFilesState;
    private TaskStateChanges inputPropertiesState;
    private TaskStateChanges taskTypeState;
    private TaskStateChanges outputFilesState;
    private SummaryTaskStateChanges allTaskChanges;
    private SummaryTaskStateChanges rebuildChanges;

    public TaskUpToDateState(TaskInternal task, TaskHistoryRepository.History history, FileCollectionSnapshotter outputFilesSnapshotter, FileCollectionSnapshotter inputFilesSnapshotter) {
        TaskExecution thisExecution = history.getCurrentExecution();
        TaskExecution lastExecution = history.getPreviousExecution();
        this.noHistoryState = NoHistoryStateChangeRule.create(task, lastExecution);
        this.taskTypeState = TaskTypeStateChangeRule.create(task, lastExecution, thisExecution);
        this.inputPropertiesState = InputPropertiesStateChangeRule.create(task, lastExecution, thisExecution);
        try {
            this.outputFilesState = this.caching(OutputFilesStateChangeRule.create(task, lastExecution, thisExecution, outputFilesSnapshotter));
        }
        catch (UncheckedIOException e) {
            throw new UncheckedIOException(String.format("Failed to capture snapshot of output files for task '%s' during up-to-date check.  See stacktrace for details.", task.getName()), (Throwable)e);
        }
        try {
            FileCollectionSnapshot inputFilesSnapshot = inputFilesSnapshotter.snapshot(task.getInputs().getFiles());
            this.inputFilesSnapshot = inputFilesSnapshot.getSnapshot();
            this.inputFilesState = this.caching(InputFilesStateChangeRule.create(lastExecution, thisExecution, inputFilesSnapshot));
        }
        catch (UncheckedIOException e) {
            throw new UncheckedIOException(String.format("Failed to capture snapshot of input files for task '%s' during up-to-date check.  See stacktrace for details.", task.getName()), (Throwable)e);
        }
        this.allTaskChanges = new SummaryTaskStateChanges(3, this.noHistoryState, this.taskTypeState, this.inputPropertiesState, this.outputFilesState, this.inputFilesState);
        this.rebuildChanges = new SummaryTaskStateChanges(1, this.noHistoryState, this.taskTypeState, this.inputPropertiesState, this.outputFilesState);
    }

    private TaskStateChanges caching(TaskStateChanges wrapped) {
        return new CachingTaskStateChanges(3, wrapped);
    }

    public TaskStateChanges getInputFilesChanges() {
        return this.inputFilesState;
    }

    public TaskStateChanges getAllTaskChanges() {
        return this.allTaskChanges;
    }

    public TaskStateChanges getRebuildChanges() {
        return this.rebuildChanges;
    }

    public FilesSnapshotSet getInputFilesSnapshot() {
        return this.inputFilesSnapshot;
    }
}

