/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;

public class GradleClassFinder
extends NonClasspathClassFinder {
    @NotNull
    private final GradleBuildClasspathManager myBuildClasspathManager;
    private final Map<String, PackageDirectoryCache> myCaches;

    public GradleClassFinder(Project project, @NotNull GradleBuildClasspathManager buildClasspathManager) {
        if (buildClasspathManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildClasspathManager", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "<init>"));
        }
        super(project, new String[]{"java", "groovy"});
        this.myCaches = new ConcurrentFactoryMap<String, PackageDirectoryCache>(){

            @Nullable
            protected PackageDirectoryCache create(String path) {
                return GradleClassFinder.createCache((List)GradleClassFinder.this.myBuildClasspathManager.getModuleClasspathEntries(path));
            }
        };
        this.myBuildClasspathManager = buildClasspathManager;
    }

    protected List<VirtualFile> calcClassRoots() {
        return this.myBuildClasspathManager.getAllClasspathEntries();
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        if (scope instanceof ExternalModuleBuildGlobalSearchScope) {
            PackageDirectoryCache packageDirectoryCache = this.myCaches.get(((ExternalModuleBuildGlobalSearchScope)scope).getExternalModulePath());
            if (packageDirectoryCache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "getCache"));
            }
            return packageDirectoryCache;
        }
        PackageDirectoryCache packageDirectoryCache = super.getCache(scope);
        if (packageDirectoryCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "getCache"));
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        super.clearCache();
        this.myCaches.clear();
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "findClass"));
        }
        PsiClass aClass = super.findClass(qualifiedName, scope);
        if (aClass == null || scope instanceof ExternalModuleBuildGlobalSearchScope || scope instanceof EverythingGlobalScope) {
            return aClass;
        }
        PsiFile containingFile = aClass.getContainingFile();
        VirtualFile file = containingFile != null ? containingFile.getVirtualFile() : null;
        return file != null && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInContent(file) ? aClass : null;
    }
}

