/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jspecview.api.JSVPanel;
import jspecview.application.AboutDialog;
import jspecview.application.MainFrame;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.ScriptToken;

public class AppToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    protected MainFrame mainFrame;
    protected JSViewer vwr;
    JToggleButton gridToggleButton;
    JToggleButton coordsToggleButton;
    JToggleButton revPlotToggleButton;
    private JButton spectraButton;
    private JButton errorLogButton;
    private ImageIcon errorLogIcon;
    private ImageIcon errorLogYellowIcon;
    private ImageIcon errorLogRedIcon;

    public AppToolBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.vwr = mainFrame.vwr;
        this.jbInit();
    }

    void setSelections(JSVPanel jsvp) {
        if (jsvp != null) {
            PanelData pd = jsvp.getPanelData();
            this.gridToggleButton.setSelected(pd.getBoolean(ScriptToken.GRIDON));
            this.coordsToggleButton.setSelected(pd.getBoolean(ScriptToken.COORDINATESON));
            this.revPlotToggleButton.setSelected(pd.getBoolean(ScriptToken.REVERSEPLOT));
        }
    }

    void setMenuEnables(PanelNode node) {
        if (node == null) {
            return;
        }
        this.setSelections(node.jsvp);
        this.spectraButton.setToolTipText("View Spectra");
    }

    void setError(boolean isError, boolean isWarningOnly) {
        this.errorLogButton.setIcon(isWarningOnly ? this.errorLogYellowIcon : (isError ? this.errorLogRedIcon : this.errorLogIcon));
        this.errorLogButton.setEnabled(isError);
    }

    private void jbInit() {
        this.addButton(null, "Open", "open24", "open");
        this.addButton(null, "Print", "print24", "print");
        this.addSeparator();
        this.gridToggleButton = new JToggleButton();
        this.addButton(this.gridToggleButton, "Toggle Grid", "grid24", "GRIDON TOGGLE");
        this.coordsToggleButton = new JToggleButton();
        this.addButton(this.coordsToggleButton, "Toggle Coordinates", "coords24", "COORDINATESON TOGGLE");
        this.revPlotToggleButton = new JToggleButton();
        this.addButton(this.revPlotToggleButton, "Reverse Plot", "reverse24", "REVERSEPLOT TOGGLE");
        this.addSeparator();
        this.addButton(null, "Previous View", "previous24", "zoom previous");
        this.addButton(null, "Next View", "next24", "zoom next");
        this.addButton(null, "Reset", "reset24", "zoom out");
        this.addButton(null, "Clear Views", "clear24", "zoom clear");
        this.addSeparator();
        this.spectraButton = new JButton();
        this.addButton(this.spectraButton, "Overlay Display", "overlay24", "view");
        this.addButton(null, "Display Key for Overlaid Spectra", "overlayKey24", "showKey TOGGLE");
        this.addSeparator();
        this.errorLogIcon = AppToolBar.getIcon("errorLog24");
        this.errorLogRedIcon = AppToolBar.getIcon("errorLogRed24");
        this.errorLogYellowIcon = AppToolBar.getIcon("errorLogYellow24");
        this.addButton(null, "Properties", "information24", "showProperties");
        this.errorLogButton = new JButton();
        this.addButton(this.errorLogButton, "Error Log", this.errorLogIcon, "SHOWERRORS");
        this.addSeparator();
        this.addButton(null, "About JSpecView", "about24", "about");
    }

    private static ImageIcon getIcon(Object name) {
        return new ImageIcon(AppToolBar.class.getResource("icons/" + name + ".gif"));
    }

    private AbstractButton addButton(AbstractButton button, String tip, Object icon, final String script) {
        if (button == null) {
            button = new JButton();
        }
        if (icon instanceof String) {
            icon = AppToolBar.getIcon(icon);
        }
        button.setBorder(null);
        button.setToolTipText(tip);
        button.setIcon((ImageIcon)icon);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (script.equals("open")) {
                    AppToolBar.this.vwr.openFileFromDialog(false, false, false, null);
                } else if (script.equals("about")) {
                    new AboutDialog(AppToolBar.this.mainFrame);
                } else {
                    AppToolBar.this.vwr.runScript(script);
                }
            }
        });
        this.add((Component)button, null);
        return button;
    }
}

