/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.PrintStream;
import org.jmol.util.Logger;
import org.jmol.util.LoggerInterface;

public class DefaultLogger
implements LoggerInterface {
    protected void log(PrintStream out, int level, String txt, Throwable e) {
        if (out == System.err) {
            System.out.flush();
        }
        if (out != null && (txt != null || e != null)) {
            StackTraceElement[] elements;
            txt = txt != null ? txt : "";
            out.println(String.valueOf(Logger.logLevel() ? "[" + Logger.getLevel(level) + "] " : "") + txt + (e != null ? ": " + e.toString() : ""));
            if (e != null && (elements = e.getStackTrace()) != null) {
                int i = 0;
                while (i < elements.length) {
                    out.println(String.valueOf(elements[i].getClassName()) + " - " + elements[i].getLineNumber() + " - " + elements[i].getMethodName());
                    ++i;
                }
            }
        }
        if (out == System.err) {
            System.err.flush();
        }
    }

    @Override
    public void debug(String txt) {
        this.log(System.out, 5, txt, null);
    }

    @Override
    public void info(String txt) {
        this.log(System.out, 4, txt, null);
    }

    @Override
    public void warn(String txt) {
        this.log(System.out, 3, txt, null);
    }

    @Override
    public void warnEx(String txt, Throwable e) {
        this.log(System.out, 3, txt, e);
    }

    @Override
    public void error(String txt) {
        this.log(System.err, 2, txt, null);
    }

    @Override
    public void errorEx(String txt, Throwable e) {
        this.log(System.err, 2, txt, e);
    }

    @Override
    public void fatal(String txt) {
        this.log(System.err, 1, txt, null);
    }

    @Override
    public void fatalEx(String txt, Throwable e) {
        this.log(System.err, 1, txt, e);
    }
}

