/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public enum ComparePairType {
    MY_WITH_THEIR(I18n.tr("My with Their", new Object[0]), new ListRole[]{ListRole.MY_ENTRIES, ListRole.THEIR_ENTRIES}),
    MY_WITH_MERGED(I18n.tr("My with Merged", new Object[0]), new ListRole[]{ListRole.MY_ENTRIES, ListRole.MERGED_ENTRIES}),
    THEIR_WITH_MERGED(I18n.tr("Their with Merged", new Object[0]), new ListRole[]{ListRole.THEIR_ENTRIES, ListRole.MERGED_ENTRIES});

    private final String displayName;
    private ListRole[] participatingRoles;

    private ComparePairType(String string2, ListRole[] listRoleArray) {
        this.displayName = string2;
        this.participatingRoles = Utils.copyArray(listRoleArray);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isParticipatingIn(ListRole listRole) {
        for (ListRole listRole2 : this.participatingRoles) {
            if (!listRole2.equals((Object)listRole)) continue;
            return true;
        }
        return false;
    }

    public ListRole[] getParticipatingRoles() {
        return this.participatingRoles;
    }

    public ListRole getOppositeRole(ListRole listRole) {
        if (!this.isParticipatingIn(listRole)) {
            throw new IllegalStateException(I18n.tr("Role {0} is not participating in compare pair {1}.", listRole.toString(), this.toString()));
        }
        if (this.participatingRoles[0].equals((Object)listRole)) {
            return this.participatingRoles[1];
        }
        return this.participatingRoles[0];
    }
}

