/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadPrimitivesWithReferrersTask
extends PleaseWaitRunnable {
    private final boolean newLayer;
    private final List<PrimitiveId> ids;
    private final boolean full;
    private final boolean downloadReferrers;
    private final OsmDataLayer tmpLayer;
    private DownloadPrimitivesTask mainTask;
    private boolean canceled;
    private PleaseWaitRunnable currentTask;

    public DownloadPrimitivesWithReferrersTask(boolean bl, List<PrimitiveId> list, boolean bl2, boolean bl3, String string, ProgressMonitor progressMonitor) {
        super(I18n.tr("Download objects", new Object[0]), progressMonitor, false);
        this.ids = list;
        this.downloadReferrers = bl2;
        this.full = bl3;
        this.newLayer = bl;
        this.tmpLayer = new OsmDataLayer(new DataSet(), string != null ? string : OsmDataLayer.createNewName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = this;
        synchronized (downloadPrimitivesWithReferrersTask) {
            this.canceled = true;
            if (this.currentTask != null) {
                this.currentTask.operationCanceled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.getProgressMonitor().setTicksCount(this.ids.size() + 1);
        this.mainTask = new DownloadPrimitivesTask(this.tmpLayer, this.ids, this.full, this.getProgressMonitor().createSubTaskMonitor(1, false));
        DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = this;
        synchronized (downloadPrimitivesWithReferrersTask) {
            this.currentTask = this.mainTask;
            if (this.canceled) {
                this.currentTask = null;
                return;
            }
        }
        this.currentTask.run();
        if (this.downloadReferrers) {
            for (PrimitiveId primitiveId : this.ids) {
                DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask2 = this;
                synchronized (downloadPrimitivesWithReferrersTask2) {
                    if (this.canceled) {
                        this.currentTask = null;
                        return;
                    }
                    this.currentTask = new DownloadReferrersTask(this.tmpLayer, primitiveId, this.getProgressMonitor().createSubTaskMonitor(1, false));
                }
                this.currentTask.run();
            }
        }
        this.currentTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finish() {
        Object object = this;
        synchronized (object) {
            if (this.canceled) {
                return;
            }
        }
        object = Main.main.getEditLayer();
        if (object == null || this.newLayer) {
            Main.main.addLayer(this.tmpLayer);
        } else {
            ((OsmDataLayer)object).mergeFrom(this.tmpLayer);
        }
        final Set<PrimitiveId> set = this.mainTask.getMissingPrimitives();
        if (set != null && !set.isEmpty()) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadPrimitivesWithReferrersTask.reportProblemDialog(set, I18n.trn("Object could not be downloaded", "Some objects could not be downloaded", set.size(), new Object[0]), I18n.trn("One object could not be downloaded.<br>", "{0} objects could not be downloaded.<br>", set.size(), set.size()) + I18n.tr("The server replied with response code 404.<br>This usually means, the server does not know an object with the requested id.", new Object[0]), I18n.tr("missing objects:", new Object[0]), 0).showDialog();
                }
            });
        }
        final HashSet<PrimitiveId> hashSet = new HashSet<PrimitiveId>();
        DataSet dataSet = Main.main.getCurrentDataSet();
        for (PrimitiveId primitiveId : this.ids) {
            OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(primitiveId);
            if (osmPrimitive == null || !osmPrimitive.isDeleted()) continue;
            hashSet.add(primitiveId);
        }
        if (!hashSet.isEmpty()) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadPrimitivesWithReferrersTask.reportProblemDialog(hashSet, I18n.trn("Object deleted", "Objects deleted", hashSet.size(), new Object[0]), I18n.trn("One downloaded object is deleted.", "{0} downloaded objects are deleted.", hashSet.size(), hashSet.size()), null, 2).showDialog();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrimitiveId> getDownloadedId() {
        Object object = this;
        synchronized (object) {
            if (this.canceled) {
                return null;
            }
        }
        object = new ArrayList<PrimitiveId>(this.ids);
        object.removeAll(this.mainTask.getMissingPrimitives());
        return object;
    }

    private static ExtendedDialog reportProblemDialog(Set<PrimitiveId> set, String string, String string2, String string3, int n) {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new HtmlPanel(string2), GBC.eop());
        JosmTextArea josmTextArea = new JosmTextArea();
        if (string3 != null) {
            jComponent = new JLabel(string3);
            jComponent.setFont(jComponent.getFont().deriveFont(0));
            jComponent.setLabelFor(josmTextArea);
            jPanel.add((Component)jComponent, GBC.eol());
        }
        josmTextArea.setFont(GuiHelper.getMonospacedFont(josmTextArea));
        josmTextArea.setEditable(false);
        josmTextArea.setBackground(jPanel.getBackground());
        josmTextArea.setColumns(40);
        josmTextArea.setRows(1);
        josmTextArea.setText(Utils.join(", ", set));
        jComponent = new JScrollPane(josmTextArea);
        jPanel.add((Component)jComponent, GBC.eop().weight(1.0, 0.0).fill(2));
        return new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Ok", new Object[0])}).setButtonIcons(new String[]{"ok"}).setIcon(n).setContent(jPanel, false);
    }
}

