/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadRestArgumentNode
extends RubyNode {
    private final int startIndex;
    private final int negativeEndIndex;
    private final boolean keywordArguments;
    private final BranchProfile noArgumentsLeftProfile = BranchProfile.create();
    private final BranchProfile subsetOfArgumentsProfile = BranchProfile.create();

    public ReadRestArgumentNode(RubyContext context, SourceSection sourceSection, int startIndex, int negativeEndIndex, boolean keywordArguments) {
        super(context, sourceSection);
        this.startIndex = startIndex;
        this.negativeEndIndex = negativeEndIndex;
        this.keywordArguments = keywordArguments;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int resultLength;
        Object[] resultStore;
        Object lastArgument;
        int count = RubyArguments.getUserArgumentsCount(frame.getArguments());
        int endIndex = count + this.negativeEndIndex;
        if (this.keywordArguments && RubyGuards.isRubyHash(lastArgument = RubyArguments.getUserArgument(frame.getArguments(), RubyArguments.getUserArgumentsCount(frame.getArguments()) - 1))) {
            --endIndex;
        }
        int length = endIndex - this.startIndex;
        if (this.startIndex == 0) {
            Object[] arguments;
            resultStore = arguments = RubyArguments.extractUserArguments(frame.getArguments());
            resultLength = length;
        } else if (this.startIndex >= endIndex) {
            this.noArgumentsLeftProfile.enter();
            resultStore = null;
            resultLength = 0;
        } else {
            this.subsetOfArgumentsProfile.enter();
            Object[] arguments = RubyArguments.extractUserArguments(frame.getArguments());
            resultStore = ArrayUtils.extractRange(arguments, this.startIndex, endIndex);
            resultLength = length;
        }
        return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), resultStore, resultLength);
    }
}

