/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child")
public abstract class ToProcNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toProc;

    public ToProcNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toProc = DispatchHeadNodeFactory.createMethodCall(context);
    }

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject doNil(Object nil) {
        return this.nil();
    }

    @Specialization(guards={"isRubyProc(proc)"})
    public DynamicObject doRubyProc(DynamicObject proc) {
        return proc;
    }

    @Specialization(guards={"!isRubyProc(object)"})
    public DynamicObject doObject(VirtualFrame frame, Object object) {
        Object coerced;
        try {
            coerced = this.toProc.call(frame, object, "to_proc", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getRubyException()) == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(object, "Proc", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyProc(coerced)) {
            return (DynamicObject)coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorBadCoercion(object, "Proc", "to_proc", coerced, this));
    }
}

