/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=FreezeNode.class)
public final class FreezeNodeGen
extends FreezeNode
implements SpecializedNode {
    @Node.Child
    private RubyNode child_;
    @CompilerDirectives.CompilationFinal
    private Class<?> childType_;
    @Node.Child
    private BaseNode_ specialization_;

    private FreezeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child_ = child;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeFreeze(Object childValue) {
        return this.specialization_.execute1(childValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static FreezeNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return new FreezeNodeGen(context, sourceSection, child);
    }

    @GeneratedBy(methodName="freeze(DynamicObject)", value=FreezeNode.class)
    private static final class Freeze5Node_
    extends BaseNode_ {
        Freeze5Node_(FreezeNodeGen root) {
            super(root, 8);
        }

        @Override
        public Object execute1(Object childValue) {
            DynamicObject childValue_;
            if (childValue instanceof DynamicObject && !this.root.isNil(childValue_ = (DynamicObject)childValue) && !RubyGuards.isRubyBignum(childValue_) && !RubyGuards.isRubySymbol(childValue_)) {
                return this.root.freeze(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new Freeze5Node_(root);
        }
    }

    @GeneratedBy(methodName="freezeSymbol(DynamicObject)", value=FreezeNode.class)
    private static final class FreezeSymbolNode_
    extends BaseNode_ {
        FreezeSymbolNode_(FreezeNodeGen root) {
            super(root, 7);
        }

        @Override
        public Object execute1(Object childValue) {
            DynamicObject childValue_;
            if (childValue instanceof DynamicObject && RubyGuards.isRubySymbol(childValue_ = (DynamicObject)childValue)) {
                return this.root.freezeSymbol(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new FreezeSymbolNode_(root);
        }
    }

    @GeneratedBy(methodName="freezeBignum(DynamicObject)", value=FreezeNode.class)
    private static final class FreezeBignumNode_
    extends BaseNode_ {
        FreezeBignumNode_(FreezeNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute1(Object childValue) {
            DynamicObject childValue_;
            if (childValue instanceof DynamicObject && RubyGuards.isRubyBignum(childValue_ = (DynamicObject)childValue)) {
                return this.root.freezeBignum(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new FreezeBignumNode_(root);
        }
    }

    @GeneratedBy(methodName="freeze(Object)", value=FreezeNode.class)
    private static final class Freeze4Node_
    extends BaseNode_ {
        Freeze4Node_(FreezeNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute1(Object childValue) {
            if (this.root.isNil(childValue)) {
                return this.root.freeze(childValue);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new Freeze4Node_(root);
        }
    }

    @GeneratedBy(methodName="freeze(double)", value=FreezeNode.class)
    private static final class Freeze3Node_
    extends BaseNode_ {
        Freeze3Node_(FreezeNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            double childValue_;
            try {
                childValue_ = this.root.child_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(ex.getResult());
            }
            return this.root.freeze(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (childValue instanceof Double) {
                double childValue_ = (Double)childValue;
                return this.root.freeze(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new Freeze3Node_(root);
        }
    }

    @GeneratedBy(methodName="freeze(long)", value=FreezeNode.class)
    private static final class Freeze2Node_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        Freeze2Node_(FreezeNodeGen root, Object childValue) {
            super(root, 3);
            this.childImplicitType = RubyTypesGen.getImplicitLongClass(childValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((Freeze2Node_)other).childImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            long childValue_;
            block4: {
                try {
                    if (this.childImplicitType == Long.TYPE) {
                        childValue_ = this.root.child_.executeLong(frameValue);
                        break block4;
                    }
                    if (this.childImplicitType == Integer.TYPE) {
                        childValue_ = RubyTypes.int2long(this.root.child_.executeInteger(frameValue));
                        break block4;
                    }
                    Object childValue__ = this.executeChild_(frameValue);
                    throw new UnexpectedResultException(childValue__);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().execute1(ex.getResult());
                }
            }
            return this.root.freeze(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (RubyTypesGen.isImplicitLong(childValue, this.childImplicitType)) {
                long childValue_ = RubyTypesGen.asImplicitLong(childValue, this.childImplicitType);
                return this.root.freeze(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root, Object childValue) {
            return new Freeze2Node_(root, childValue);
        }
    }

    @GeneratedBy(methodName="freeze(int)", value=FreezeNode.class)
    private static final class Freeze1Node_
    extends BaseNode_ {
        Freeze1Node_(FreezeNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int childValue_;
            try {
                childValue_ = this.root.child_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(ex.getResult());
            }
            return this.root.freeze(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (childValue instanceof Integer) {
                int childValue_ = (Integer)childValue;
                return this.root.freeze(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new Freeze1Node_(root);
        }
    }

    @GeneratedBy(methodName="freeze(boolean)", value=FreezeNode.class)
    private static final class Freeze0Node_
    extends BaseNode_ {
        Freeze0Node_(FreezeNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean childValue_;
            try {
                childValue_ = this.root.child_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(ex.getResult());
            }
            return this.root.freeze(childValue_);
        }

        @Override
        public Object execute1(Object childValue) {
            if (childValue instanceof Boolean) {
                boolean childValue_ = (Boolean)childValue;
                return this.root.freeze(childValue_);
            }
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new Freeze0Node_(root);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(FreezeNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object childValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, childValue));
        }

        @Override
        public Object execute1(Object childValue) {
            return this.getNext().execute1(childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(FreezeNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute1(Object childValue) {
            return this.uninitialized((Frame)null, childValue);
        }

        static BaseNode_ create(FreezeNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=FreezeNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final FreezeNodeGen root;

        BaseNode_(FreezeNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.child_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object childValue) {
            return this.execute1(childValue);
        }

        public abstract Object execute1(Object var1);

        public Object execute0(VirtualFrame frameValue) {
            Object childValue_ = this.executeChild_(frameValue);
            return this.execute1(childValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object childValue) {
            if (childValue instanceof Boolean) {
                return Freeze0Node_.create(this.root);
            }
            if (childValue instanceof Integer) {
                return Freeze1Node_.create(this.root);
            }
            if (RubyTypesGen.isImplicitLong(childValue)) {
                return Freeze2Node_.create(this.root, childValue);
            }
            if (childValue instanceof Double) {
                return Freeze3Node_.create(this.root);
            }
            if (this.root.isNil(childValue)) {
                return Freeze4Node_.create(this.root);
            }
            if (childValue instanceof DynamicObject) {
                DynamicObject childValue_ = (DynamicObject)childValue;
                if (RubyGuards.isRubyBignum(childValue_)) {
                    return FreezeBignumNode_.create(this.root);
                }
                if (RubyGuards.isRubySymbol(childValue_)) {
                    return FreezeSymbolNode_.create(this.root);
                }
                if (!(this.root.isNil(childValue_) || RubyGuards.isRubyBignum(childValue_) || RubyGuards.isRubySymbol(childValue_))) {
                    return Freeze5Node_.create(this.root);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeChild_(Frame frameValue) {
            Object object;
            Class childType_ = this.root.childType_;
            if (childType_ == Boolean.TYPE) {
                return this.root.child_.executeBoolean((VirtualFrame)frameValue);
            }
            if (childType_ == Double.TYPE) {
                return this.root.child_.executeDouble((VirtualFrame)frameValue);
            }
            if (childType_ == Integer.TYPE) {
                return this.root.child_.executeInteger((VirtualFrame)frameValue);
            }
            if (childType_ == Long.TYPE) {
                return this.root.child_.executeLong((VirtualFrame)frameValue);
            }
            if (childType_ != null) return this.root.child_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.child_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.childType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.childType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.childType_ = _type;
            return object;
        }
    }
}

