/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class DirPrimitiveNodes {

    @RubiniusPrimitive(name="dir_close")
    public static abstract class DirClosePrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirClosePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject open(DynamicObject dir) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_control")
    public static abstract class DirControlPrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirControlPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object control(DynamicObject dir, int kind, int position) {
            switch (kind) {
                case 0: {
                    Layouts.DIR.setPosition(dir, position);
                    return true;
                }
                case 1: {
                    Layouts.DIR.setPosition(dir, -2);
                    return true;
                }
                case 2: {
                    return Layouts.DIR.getPosition(dir);
                }
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_read")
    public static abstract class DirReadPrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirReadPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object read(DynamicObject dir) {
            int position = Layouts.DIR.getPosition(dir);
            Layouts.DIR.setPosition(dir, position + 1);
            if (position == -2) {
                return this.create7BitString(StringOperations.encodeByteList(".", (Encoding)UTF8Encoding.INSTANCE));
            }
            if (position == -1) {
                return this.create7BitString(StringOperations.encodeByteList("..", (Encoding)UTF8Encoding.INSTANCE));
            }
            String[] contents = (String[])Layouts.DIR.getContents(dir);
            if (position < contents.length) {
                return this.createString(StringOperations.encodeByteList(contents[position], (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_open")
    public static abstract class DirOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isNil(encoding)"})
        public DynamicObject open(DynamicObject dir, DynamicObject path, DynamicObject encoding) {
            File file = new File(path.toString());
            if (!file.isDirectory()) {
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(Errno.ENOTDIR.intValue(), this));
            }
            String[] contents = file.list();
            if (contents == null) {
                throw new UnsupportedOperationException();
            }
            Layouts.DIR.setContents(dir, contents);
            Layouts.DIR.setPosition(dir, -2);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)", "isRubyEncoding(encoding)"})
        public DynamicObject openEncoding(DynamicObject dir, DynamicObject path, DynamicObject encoding) {
            return this.open(dir, path, this.nil());
        }
    }

    @RubiniusPrimitive(name="dir_allocate")
    public static abstract class DirAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject dirClass) {
            return Layouts.DIR.createDir(Layouts.CLASS.getInstanceFactory(dirClass), null, 0);
        }
    }
}

