/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import org.jruby.truffle.format.parser.FormatDirective;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

public class FormatTokenizer {
    private static final String TYPE_CHARS = "%-sdiuxXfgGeE";
    private final RubyContext context;
    private final ByteList format;
    private int position;

    public FormatTokenizer(RubyContext context, ByteList format) {
        this.context = context;
        this.format = format;
    }

    public Object next() {
        char type;
        int precision;
        int zeroPadding;
        int spacePadding;
        if (this.position >= this.format.length()) {
            return null;
        }
        char c = this.format.charAt(this.position);
        if (c != '%') {
            int stringStart = this.position++;
            while (this.position < this.format.length() && this.format.charAt(this.position) != '%') {
                ++this.position;
            }
            return this.format.subSequence(stringStart, this.position);
        }
        ++this.position;
        Object key = null;
        if (this.format.charAt(this.position) == '{') {
            ++this.position;
            key = this.readUntil('}');
            ++this.position;
            return new FormatDirective(0, 0, false, 0, '{', key);
        }
        if (this.format.charAt(this.position) == '<') {
            ++this.position;
            key = this.readUntil('>');
            ++this.position;
        }
        boolean leftJustified = false;
        if (this.position < this.format.length() && this.format.charAt(this.position) == '-') {
            leftJustified = true;
            ++this.position;
        }
        if (this.position < this.format.length() && this.format.charAt(this.position) == ' ') {
            ++this.position;
            spacePadding = this.readInt();
            zeroPadding = -1;
        } else if (this.position < this.format.length() && this.format.charAt(this.position) == '0') {
            ++this.position;
            spacePadding = -1;
            zeroPadding = this.readInt();
        } else if (this.position < this.format.length() && Character.isDigit(this.format.charAt(this.position))) {
            spacePadding = this.readInt();
            zeroPadding = -1;
        } else {
            spacePadding = -1;
            if (this.position < this.format.length() && this.format.charAt(this.position) == '0') {
                ++this.position;
                zeroPadding = this.readInt();
            } else {
                zeroPadding = -1;
            }
        }
        if (this.position < this.format.length() && this.format.charAt(this.position) == '.') {
            ++this.position;
            precision = this.readInt();
        } else {
            precision = -1;
        }
        if (this.position < this.format.length() && Character.isDigit(this.format.charAt(this.position))) {
            spacePadding = this.readInt();
        }
        if (key != null && this.position >= this.format.length()) {
            type = 's';
        } else {
            type = this.format.charAt(this.position);
            if (key != null && Character.isWhitespace(type)) {
                type = 's';
            } else if (TYPE_CHARS.indexOf(type) == -1) {
                throw new UnsupportedOperationException("Unknown format type '" + this.format.charAt(this.position) + "'");
            }
            ++this.position;
        }
        return new FormatDirective(spacePadding, zeroPadding, leftJustified, precision, type, key);
    }

    private int readInt() {
        int start = this.position;
        while (Character.isDigit(this.format.charAt(this.position))) {
            ++this.position;
        }
        if (this.position == start && this.format.charAt(this.position) == '*') {
            ++this.position;
            return -2;
        }
        return Integer.parseInt(this.format.subSequence(start, this.position).toString());
    }

    private Object readUntil(char end) {
        int start = this.position;
        while (this.format.charAt(this.position) != end) {
            ++this.position;
        }
        return this.context.getSymbol((ByteList)this.format.subSequence(start, this.position));
    }
}

