<?php
/**
 * Script to update list of supported lexers.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 * @author Ori Livneh <ori@wikimedia.org>
 * @ingroup Maintenance
 */

use KzykHys\Pygments\Pygments;

$IP = getenv( 'MW_INSTALL_PATH' ) ?: __DIR__ . '/../../..';

require_once "$IP/maintenance/Maintenance.php";

class UpdateLanguageList extends Maintenance {
	public function __construct() {
		parent::__construct();
		$this->addDescription( 'Update list of lexers supported by SyntaxHighlight_GeSHi' );
	}

	public function execute() {
		global $wgPygmentizePath;

		function lang_filter( $val ) {
			return preg_match( '/^[a-zA-Z0-9\-_]+$/', $val );
		}

		$header = '// Generated by ' . basename( __FILE__ ) . "\n\n";

		$pygments = new Pygments( $wgPygmentizePath );
		$lexers = array_keys( $pygments->getLexers() );
		sort( $lexers );

		$code = "<?php\n" .  $header .  'return ' . var_export( $lexers, true ) . ";\n";
		$code = preg_replace( '/(\d+ \=\>| (?=\())/i', '', $code );
		$code = preg_replace( "/^ +/m", "\t", $code );

		file_put_contents( __DIR__ . '/../SyntaxHighlight_GeSHi.lexers.php', $code );
		$this->output( "Updated language list written to SyntaxHighlight_GeSHi.lexers.php\n" );
	}
}

$maintClass = "UpdateLanguageList";
require_once ( RUN_MAINTENANCE_IF_MAIN );
