/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.type1;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;

public class Type1Font {
    private AFM afm;
    private ILocator locator;

    public static Type1Font createFromLocator(ILocator iLocator) throws IOException {
        Type1Font type1Font = new Type1Font();
        type1Font.setLocator(iLocator);
        type1Font.initializeFromLocator();
        return type1Font;
    }

    public Type1Font() {
    }

    public Type1Font(AFM aFM) {
        this.afm = aFM;
    }

    public String getFontFamilyName() {
        return FontTools.getFontFamilyName(this.getFontName());
    }

    public synchronized AFM getFontMetrics() {
        return this.afm;
    }

    public String getFontName() {
        return this.afm.getFontName();
    }

    public FontStyle getFontStyle() {
        return FontTools.getFontStyle(this.getFontName());
    }

    public ILocator getLocator() {
        return this.locator;
    }

    protected void initializeAfm() throws IOException {
        ILocator iLocator = this.getLocator().getParent();
        if (iLocator == null) {
            return;
        }
        String string = this.getLocator().getLocalName();
        ILocator iLocator2 = iLocator.getChild(String.valueOf(string) + ".afm");
        this.afm = AFM.createFromLocator(iLocator2);
    }

    protected void initializeFromLocator() throws IOException {
        this.initializePfb();
        this.initializeAfm();
    }

    protected void initializePfb() {
    }

    public boolean isSymbolFont() {
        return false;
    }

    protected void setLocator(ILocator iLocator) {
        this.locator = iLocator;
    }
}

