/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeShortType;
import de.intarsys.nativec.type.NativeType;

public class NativeShort
extends NativeNumber {
    public static final NativeShortType META = new NativeShortType();

    static {
        NativeType.register(NativeShort.class, META);
    }

    public static NativeShort createFromAddress(long l) {
        return (NativeShort)META.createNative(NativeTools.toHandle(l));
    }

    public NativeShort() {
        this.allocate();
    }

    protected NativeShort(INativeHandle iNativeHandle) {
        super(iNativeHandle);
    }

    public NativeShort(short s) {
        this.allocate();
        this.setValue(s);
    }

    @Override
    public byte byteValue() {
        return (byte)this.shortValue();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    @Override
    public Object getValue() {
        return new Short(this.shortValue());
    }

    @Override
    public int intValue() {
        return this.shortValue();
    }

    @Override
    public long longValue() {
        return this.shortValue();
    }

    @Override
    public void setValue(Object object) {
        this.setValue(((Number)object).shortValue());
    }

    public void setValue(short s) {
        this.handle.setShort(0, s);
    }

    @Override
    public short shortValue() {
        return this.handle.getShort(0);
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.shortValue());
    }
}

