/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.collection.ArrayTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMTools {
    public static final Element[] NO_ELEMENTS = new Element[0];

    public static Iterator<Attr> getAttributeIterator(Element element) {
        final NamedNodeMap namedNodeMap = element.getAttributes();
        return new Iterator<Attr>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < namedNodeMap.getLength();
            }

            @Override
            public Attr next() {
                return (Attr)namedNodeMap.item(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int getAttrInt(Element element, String string, int n) {
        String string2 = element.getAttribute(string);
        if (StringTools.isEmpty(string2)) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static String getAttrString(Element element, String string, String string2) {
        String string3 = element.getAttribute(string);
        if (StringTools.isEmpty(string3)) {
            return string2;
        }
        return string3;
    }

    public static Element getDirectChild(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            if (nodeList.item(n).getNodeType() == 1 && string.equals((element2 = (Element)nodeList.item(n)).getLocalName())) {
                return element2;
            }
            ++n;
        }
        return null;
    }

    public static Element[] getDirectChildren(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            return NO_ELEMENTS;
        }
        return DOMTools.toElementArray(nodeList);
    }

    public static Element[] getDirectChildren(Element element, String string) {
        Element[] elementArray = DOMTools.getDirectChildren(element);
        if (elementArray.length == 0) {
            return elementArray;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element[] elementArray2 = elementArray;
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element element2 = elementArray2[n2];
            if (element2.getLocalName().equals(string)) {
                arrayList.add(element2);
            }
            ++n2;
        }
        return (Element[])ArrayTools.toArray(Element.class, arrayList);
    }

    public static Element getElement(Document document, String string) {
        Element element = document.getDocumentElement();
        return DOMTools.getElement(element, string);
    }

    public static Element getElement(Element element, String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            NodeList nodeList = element.getElementsByTagNameNS("*", stringArray[0]);
            if (nodeList.getLength() == 0) {
                return null;
            }
            return (Element)nodeList.item(0);
        }
        int n = 0;
        while (n < stringArray.length) {
            if ((element = DOMTools.getElement(element, stringArray[n])) == null) {
                return null;
            }
            ++n;
        }
        return element;
    }

    public static Iterator<Element> getElementIterator(Element element) {
        final NodeList nodeList = element.getElementsByTagNameNS("*", "*");
        return new Iterator<Element>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < nodeList.getLength();
            }

            @Override
            public Element next() {
                return (Element)nodeList.item(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Element> getElementIterator(Element element, String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            final NodeList nodeList = element.getElementsByTagNameNS("*", stringArray[0]);
            return new Iterator<Element>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < nodeList.getLength();
                }

                @Override
                public Element next() {
                    return (Element)nodeList.item(this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        int n = 0;
        while (n < stringArray.length - 1) {
            if ((element = DOMTools.getElement(element, stringArray[n])) == null) {
                return null;
            }
            ++n;
        }
        return DOMTools.getElementIterator(element, stringArray[stringArray.length - 1]);
    }

    public static Element[] getElements(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("*", "*");
        return DOMTools.toElementArray(nodeList);
    }

    public static Element[] getElements(Element element, String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            NodeList nodeList = element.getElementsByTagNameNS("*", stringArray[0]);
            return DOMTools.toElementArray(nodeList);
        }
        int n = 0;
        while (n < stringArray.length - 1) {
            if ((element = DOMTools.getElement(element, stringArray[n])) == null) {
                return null;
            }
            ++n;
        }
        return DOMTools.getElements(element, stringArray[stringArray.length - 1]);
    }

    public static Element getFirstDirectChild(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                return (Element)nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    public static Map<String, String> getNamespaceDeclarations(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            if ("xmlns".equals(node.getPrefix())) {
                String string = node.getLocalName();
                String string2 = node.getTextContent();
                hashMap.put(string, string2);
            }
            ++n;
        }
        return hashMap;
    }

    public static Element parseElement(byte[] byArray) throws IOException, SAXException {
        InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
        return DOMTools.parseElement(inputSource);
    }

    public static Element parseElement(File file) throws IOException, SAXException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 10000);
        return DOMTools.parseElement(bufferedInputStream, true);
    }

    protected static Element parseElement(InputSource inputSource) throws IOException, SAXException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("parser configuration error", parserConfigurationException);
        }
        Document document = documentBuilder.parse(inputSource);
        return document.getDocumentElement();
    }

    public static Element parseElement(InputStream inputStream, boolean bl) throws IOException, SAXException {
        try {
            InputSource inputSource = new InputSource(inputStream);
            Element element = DOMTools.parseElement(inputSource);
            return element;
        }
        finally {
            if (bl) {
                StreamTools.close(inputStream);
            }
        }
    }

    public static Element parseElement(String string) throws IOException, SAXException {
        InputSource inputSource = new InputSource(new StringReader(string));
        return DOMTools.parseElement(inputSource);
    }

    public static Element[] toElementArray(NodeList nodeList) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                arrayList.add((Element)nodeList.item(n));
            }
            ++n;
        }
        return (Element[])ArrayTools.toArray(Element.class, arrayList);
    }

    private DOMTools() {
    }
}

