/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectmodel;

import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.objectmodel.Class;
import de.intarsys.tools.objectmodel.ClassRegistry;
import de.intarsys.tools.objectmodel.IClass;
import de.intarsys.tools.objectmodel.IClassSelector;
import de.intarsys.tools.objectmodel.IField;
import de.intarsys.tools.objectmodel.IMethod;
import de.intarsys.tools.objectmodel.InvokeAccept;
import de.intarsys.tools.objectmodel.InvokeIntercept;
import de.intarsys.tools.objectmodel.JavaClassSelector;
import de.intarsys.tools.objectmodel.JavaInstanceSelector;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.FieldNotFoundException;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodInvocationException;
import de.intarsys.tools.reflect.MethodNotFoundException;
import de.intarsys.tools.reflect.ObjectCreationException;

public class ObjectModelTools {
    public static IClassSelector createSelector(String string) throws ObjectCreationException {
        String[] stringArray = string.split(":");
        java.lang.Class<Object> clazz = ClassTools.createClass(stringArray[0], Object.class, null);
        if (stringArray.length > 1) {
            return new JavaInstanceSelector(clazz, stringArray[1]);
        }
        return new JavaClassSelector(clazz);
    }

    public static Object get(Object object, Object object2, String string) throws FieldException {
        if (object == null) {
            throw new NullPointerException("can not call '" + string + "' for 'null'");
        }
        IField iField = ObjectModelTools.lookupField(object.getClass(), object2, string);
        return iField.getValue(object);
    }

    public static Object get(Object object, String string) throws FieldException {
        if (object == null) {
            throw new NullPointerException("can not call '" + string + "' for 'null'");
        }
        IField iField = ObjectModelTools.lookupField(object.getClass(), string);
        return iField.getValue(object);
    }

    public static Object invoke(Object object, Object object2, String string, IArgs iArgs) throws MethodException {
        if (object == null) {
            throw new NullPointerException("can't call '" + string + "' for 'null'");
        }
        IMethod iMethod = ObjectModelTools.lookupMethod(object.getClass(), object2, string);
        return iMethod.invoke(object, iArgs);
    }

    public static Object invoke(Object object, String string, IArgs iArgs) throws MethodException {
        if (object == null) {
            throw new NullPointerException("can't call '" + string + "' for 'null'");
        }
        IMethod iMethod = ObjectModelTools.lookupMethod(object.getClass(), string);
        return iMethod.invoke(object, iArgs);
    }

    protected static Object invokeIntercept(Object object, INotificationListener iNotificationListener, IMethod iMethod, IArgs iArgs) throws MethodInvocationException {
        InvokeIntercept invokeIntercept = new InvokeIntercept(object, iNotificationListener, iMethod, iArgs);
        iNotificationListener.handleEvent(invokeIntercept);
        if (invokeIntercept.isVetoed()) {
            return invokeIntercept.getResult();
        }
        return ObjectModelTools.invokeInterceptResume(object, iNotificationListener, iMethod, iArgs);
    }

    public static Object invokeIntercept(Object object, INotificationListener iNotificationListener, String string, IArgs iArgs) throws MethodException {
        if (object == null) {
            throw new NullPointerException("can't call '" + string + "' for 'null'");
        }
        IMethod iMethod = ObjectModelTools.lookupMethod(object.getClass(), string);
        return ObjectModelTools.invokeIntercept(object, iNotificationListener, iMethod, iArgs);
    }

    public static Object invokeIntercept(Object object, Object object2, INotificationListener iNotificationListener, String string, IArgs iArgs) throws MethodException {
        if (object == null) {
            throw new NullPointerException("can't call '" + string + "' for 'null'");
        }
        IMethod iMethod = ObjectModelTools.lookupMethod(object.getClass(), object2, string);
        return ObjectModelTools.invokeIntercept(object, iNotificationListener, iMethod, iArgs);
    }

    protected static Object invokeInterceptResume(Object object, INotificationListener iNotificationListener, IMethod iMethod, IArgs iArgs) throws MethodInvocationException {
        Object object2 = iMethod.invoke(object, iArgs);
        InvokeAccept invokeAccept = new InvokeAccept(iMethod, object, iArgs);
        invokeAccept.setResult(object2);
        iNotificationListener.handleEvent(invokeAccept);
        return invokeAccept.getResult();
    }

    public static IClass lookupClass(IClassSelector iClassSelector) {
        IClass iClass = ClassRegistry.get().lookupClass(iClassSelector);
        if (iClass == null) {
            iClass = new Class(iClassSelector);
            ClassRegistry.get().registerClass(iClass);
        }
        return iClass;
    }

    public static IClass lookupClass(java.lang.Class<?> clazz) {
        JavaClassSelector javaClassSelector = new JavaClassSelector(clazz);
        return ObjectModelTools.lookupClass(javaClassSelector);
    }

    public static IClass lookupClass(java.lang.Class<?> clazz, Object object) {
        JavaInstanceSelector javaInstanceSelector = new JavaInstanceSelector(clazz, object);
        return ObjectModelTools.lookupClass(javaInstanceSelector);
    }

    public static IField lookupField(java.lang.Class<?> clazz, Object object, String string) throws FieldNotFoundException {
        JavaInstanceSelector javaInstanceSelector = new JavaInstanceSelector(clazz, object);
        IField iField = null;
        IClass iClass = ClassRegistry.get().lookupClass(javaInstanceSelector);
        if (iClass != null && (iField = iClass.lookupField(string)) != null) {
            return iField;
        }
        java.lang.Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            try {
                iField = ObjectModelTools.lookupField(clazz2, object, string);
                if (iField != null) {
                    return iField;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            try {
                iField = ObjectModelTools.lookupField(classArray[n], object, string);
                if (iField != null) {
                    return iField;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return ObjectModelTools.lookupField(clazz, string);
    }

    public static IField lookupField(java.lang.Class<?> clazz, String string) throws FieldNotFoundException {
        JavaClassSelector javaClassSelector = new JavaClassSelector(clazz);
        IField iField = null;
        IClass iClass = ClassRegistry.get().lookupClass(javaClassSelector);
        if (iClass != null && (iField = iClass.lookupField(string)) != null) {
            return iField;
        }
        java.lang.Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            try {
                iField = ObjectModelTools.lookupField(clazz2, string);
                if (iField != null) {
                    return iField;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            try {
                iField = ObjectModelTools.lookupField(classArray[n], string);
                if (iField != null) {
                    return iField;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        throw new FieldNotFoundException(string);
    }

    public static IMethod lookupMethod(java.lang.Class<?> clazz, Object object, String string) throws MethodNotFoundException {
        JavaInstanceSelector javaInstanceSelector = new JavaInstanceSelector(clazz, object);
        IMethod iMethod = null;
        IClass iClass = ClassRegistry.get().lookupClass(javaInstanceSelector);
        if (iClass != null && (iMethod = iClass.lookupMethod(string)) != null) {
            return iMethod;
        }
        java.lang.Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            try {
                iMethod = ObjectModelTools.lookupMethod(clazz2, object, string);
                if (iMethod != null) {
                    return iMethod;
                }
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            try {
                iMethod = ObjectModelTools.lookupMethod(classArray[n], object, string);
                if (iMethod != null) {
                    return iMethod;
                }
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
            ++n;
        }
        return ObjectModelTools.lookupMethod(clazz, string);
    }

    public static IMethod lookupMethod(java.lang.Class<?> clazz, String string) throws MethodNotFoundException {
        JavaClassSelector javaClassSelector = new JavaClassSelector(clazz);
        IMethod iMethod = null;
        IClass iClass = ClassRegistry.get().lookupClass(javaClassSelector);
        if (iClass != null && (iMethod = iClass.lookupMethod(string)) != null) {
            return iMethod;
        }
        java.lang.Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            try {
                iMethod = ObjectModelTools.lookupMethod(clazz2, string);
                if (iMethod != null) {
                    return iMethod;
                }
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
        }
        java.lang.Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            try {
                iMethod = ObjectModelTools.lookupMethod(classArray[n], string);
                if (iMethod != null) {
                    return iMethod;
                }
            }
            catch (MethodNotFoundException methodNotFoundException) {
                // empty catch block
            }
            ++n;
        }
        throw new MethodNotFoundException(string);
    }

    public static void registerClass(IClassSelector iClassSelector) {
        IClass iClass = ClassRegistry.get().lookupClass(iClassSelector);
        if (iClass == null) {
            iClass = new Class(iClassSelector);
            ClassRegistry.get().registerClass(iClass);
        }
    }

    public static void registerClass(java.lang.Class<?> clazz) {
        JavaClassSelector javaClassSelector = new JavaClassSelector(clazz);
        ObjectModelTools.registerClass(javaClassSelector);
    }

    public static void registerClass(java.lang.Class<?> clazz, Object object) {
        JavaInstanceSelector javaInstanceSelector = new JavaInstanceSelector(clazz, object);
        ObjectModelTools.registerClass(javaInstanceSelector);
    }

    public static void registerField(IClassSelector iClassSelector, IField iField) {
        IClass iClass = ClassRegistry.get().lookupClass(iClassSelector);
        if (iClass == null) {
            iClass = new Class(iClassSelector);
            ClassRegistry.get().registerClass(iClass);
        }
        ((Class)iClass).registerField(iField);
    }

    public static void registerField(java.lang.Class<?> clazz, IField iField) {
        JavaClassSelector javaClassSelector = new JavaClassSelector(clazz);
        ObjectModelTools.registerField(javaClassSelector, iField);
    }

    public static void registerField(java.lang.Class<?> clazz, Object object, IField iField) {
        JavaInstanceSelector javaInstanceSelector = new JavaInstanceSelector(clazz, object);
        ObjectModelTools.registerField(javaInstanceSelector, iField);
    }

    public static void registerMethod(IClassSelector iClassSelector, IMethod iMethod) {
        IClass iClass = ClassRegistry.get().lookupClass(iClassSelector);
        if (iClass == null) {
            iClass = new Class(iClassSelector);
            ClassRegistry.get().registerClass(iClass);
        }
        ((Class)iClass).registerMethod(iMethod);
    }

    public static void registerMethod(java.lang.Class<?> clazz, IMethod iMethod) {
        JavaClassSelector javaClassSelector = new JavaClassSelector(clazz);
        ObjectModelTools.registerMethod(javaClassSelector, iMethod);
    }

    public static void registerMethod(java.lang.Class<?> clazz, Object object, IMethod iMethod) {
        JavaInstanceSelector javaInstanceSelector = new JavaInstanceSelector(clazz, object);
        ObjectModelTools.registerMethod(javaInstanceSelector, iMethod);
    }

    public static void set(Object object, Object object2, String string, Object object3) throws FieldException {
        if (object == null) {
            throw new NullPointerException("can not call '" + string + "' for 'null'");
        }
        IField iField = ObjectModelTools.lookupField(object.getClass(), object2, string);
        iField.setValue(object, object3);
    }

    public static void set(Object object, String string, Object object2) throws FieldException {
        if (object == null) {
            throw new NullPointerException("can not call '" + string + "' for 'null'");
        }
        IField iField = ObjectModelTools.lookupField(object.getClass(), string);
        iField.setValue(object, object2);
    }
}

