/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.ReaderTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;

public class TaggedReader
extends Reader {
    private final Map<String, String> properties;
    private final Reader reader;
    private final BufferedReader buffer;

    public TaggedReader(Reader reader, int n) throws IOException {
        this.reader = reader;
        this.buffer = new BufferedReader(reader, n);
        this.properties = ReaderTools.readMetaData(this.buffer);
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public String getEncoding() {
        if (this.reader instanceof InputStreamReader) {
            return ((InputStreamReader)this.reader).getEncoding();
        }
        return null;
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public Iterator<String> getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    @Override
    public void mark(int n) throws IOException {
        this.buffer.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.buffer.markSupported();
    }

    public void putProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    @Override
    public int read() throws IOException {
        return this.buffer.read();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.buffer.read(cArray, n, n2);
    }

    @Override
    public boolean ready() throws IOException {
        return this.buffer.ready();
    }

    @Override
    public void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.buffer.skip(l);
    }
}

