/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.transaction;

import de.intarsys.tools.transaction.IResource;
import de.intarsys.tools.transaction.IResourceType;
import de.intarsys.tools.transaction.NoTransactionException;
import de.intarsys.tools.transaction.Transaction;
import de.intarsys.tools.transaction.TransactionException;
import de.intarsys.tools.transaction.TransactionManager;

public class TransactionTools {
    public static void delist(IResource iResource) throws TransactionException {
        Transaction transaction = (Transaction)TransactionManager.get().getTransaction();
        if (transaction == null) {
            throw new NoTransactionException();
        }
        transaction.delist(iResource);
    }

    public static void enlist(IResource iResource) throws TransactionException {
        Transaction transaction = (Transaction)TransactionManager.get().getTransaction();
        if (transaction == null) {
            throw new NoTransactionException();
        }
        transaction.enlist(iResource);
    }

    public static <T extends IResource> T getResource(IResourceType<T> iResourceType, boolean bl) throws TransactionException {
        Transaction transaction = (Transaction)TransactionManager.get().getTransaction();
        if (transaction == null) {
            throw new NoTransactionException();
        }
        return TransactionTools.getResource(iResourceType, transaction, bl);
    }

    protected static <T extends IResource> T getResource(IResourceType<T> iResourceType, Transaction transaction, boolean bl) throws TransactionException {
        T t = transaction.getResource(iResourceType);
        if (t == null) {
            if (bl) {
                Object t2 = null;
                Transaction transaction2 = (Transaction)transaction.getParent();
                if (transaction2 != null) {
                    t2 = TransactionTools.getResource(iResourceType, transaction2, bl);
                }
                t = iResourceType.createResource(t2);
                transaction.enlist((IResource)t);
            } else {
                throw new TransactionException("no resource found");
            }
        }
        return t;
    }
}

