/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.thumbnails.creators;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PInfo;
import org.pdfsam.guiclient.business.thumbnails.callables.IcdPdfCreatorCloser;
import org.pdfsam.guiclient.business.thumbnails.callables.IcePdfThumbnailCallable;
import org.pdfsam.guiclient.business.thumbnails.creators.AbstractThumbnailCreator;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.DocumentInfo;
import org.pdfsam.guiclient.dto.DocumentPage;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.exceptions.ThumbnailCreationException;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.i18n.GettextResource;

public class IcePdfThumbnailsCreator
extends AbstractThumbnailCreator {
    public static final int ICEPDF_RESOLUTION = 72;
    private static final String ICEPDF_CREATOR_NAME = "ICEpdf";
    private static final Logger log = Logger.getLogger((String)IcePdfThumbnailsCreator.class.getPackage().getName());
    private Document pdfDocument = null;

    protected void finalizeThumbnailsCreation() throws ThumbnailCreationException {
    }

    protected Callable<Boolean> getCloserTask() throws ThumbnailCreationException {
        IcdPdfCreatorCloser retVal = null;
        if (this.pdfDocument != null) {
            retVal = new IcdPdfCreatorCloser(this.pdfDocument);
        }
        return retVal;
    }

    protected DocumentInfo getDocumentInfo() throws ThumbnailCreationException {
        File inputFile = this.getInputFile();
        DocumentInfo documentInfo = new DocumentInfo();
        documentInfo.setFileName(inputFile.getAbsolutePath());
        documentInfo.setPages(this.pdfDocument.getNumberOfPages());
        documentInfo.setPdfVersion("");
        documentInfo.setEncrypted(this.pdfDocument.getSecurityManager() != null);
        PInfo info = this.pdfDocument.getInfo();
        if (info != null) {
            documentInfo.getDocumentMetaData().setAuthor(info.getAuthor());
            documentInfo.getDocumentMetaData().setCreator(info.getCreator());
            documentInfo.getDocumentMetaData().setTitle(info.getTitle());
            documentInfo.getDocumentMetaData().setProducer(info.getProducer());
        }
        return documentInfo;
    }

    protected Vector<VisualPageListItem> getDocumentModel(List<DocumentPage> template) throws ThumbnailCreationException {
        int pages = this.pdfDocument.getNumberOfPages();
        File inputFile = this.getInputFile();
        Vector<VisualPageListItem> modelList = null;
        try {
            if (pages > 0 && inputFile != null) {
                modelList = new Vector<VisualPageListItem>(pages);
                if (template == null || template.size() <= 0) {
                    for (int i = 1; i <= pages; ++i) {
                        modelList.add(new VisualPageListItem(i, inputFile.getCanonicalPath(), this.getProvidedPassword()));
                    }
                } else {
                    for (DocumentPage page : template) {
                        if (page.getPageNumber() <= 0 || page.getPageNumber() > pages) continue;
                        VisualPageListItem currentItem = new VisualPageListItem(page.getPageNumber(), inputFile.getCanonicalPath(), this.getProvidedPassword());
                        currentItem.setDeleted(page.isDeleted());
                        currentItem.setRotation(page.getRotation());
                        modelList.add(currentItem);
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error opening pdf document") + " " + inputFile.getAbsolutePath(), (Throwable)ioe);
        }
        return modelList;
    }

    protected Collection<? extends Callable<Boolean>> getGenerationTasks(Vector<VisualPageListItem> modelList) throws ThumbnailCreationException {
        ArrayList<IcePdfThumbnailCallable> tasks = null;
        if (this.pdfDocument != null && modelList != null && modelList.size() > 0) {
            tasks = new ArrayList<IcePdfThumbnailCallable>(modelList.size());
            for (VisualPageListItem pageItem : modelList) {
                tasks.add(new IcePdfThumbnailCallable(this.pdfDocument, pageItem, this.getPanel(), this.getCurrentId()));
            }
        }
        return tasks;
    }

    protected void initThumbnailsCreation() throws ThumbnailCreationException {
    }

    protected boolean openInputDocument() throws ThumbnailCreationException {
        boolean retVal = false;
        File inputFile = this.getInputFile();
        if (inputFile != null && inputFile.exists() && inputFile.isFile()) {
            try {
                this.pdfDocument = this.openDocument(inputFile, this.getProvidedPassword());
                retVal = true;
            }
            catch (Exception e) {
                throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error opening pdf document") + " " + inputFile.getAbsolutePath(), (Throwable)e);
            }
        } else {
            log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Input file doesn't exists or is a directory"));
        }
        return retVal;
    }

    private Document openDocument(File inputFile, String providedPwd) throws PDFException, PDFSecurityException, IOException, NullPointerException {
        Document retVal = null;
        retVal = new Document();
        retVal.setSecurityCallback(new ModalSecurityCallbak(inputFile, providedPwd));
        retVal.setFile(inputFile.getCanonicalPath());
        return retVal;
    }

    public String getCreatorIdentifier() {
        return IcePdfThumbnailsCreator.class.getName();
    }

    public String getCreatorName() {
        return ICEPDF_CREATOR_NAME;
    }

    public BufferedImage getPageImage(File fileName, String password, int page, int rotation) throws ThumbnailCreationException {
        BufferedImage retVal = null;
        if (fileName != null && fileName.exists() && fileName.isFile()) {
            try {
                Document pdfDocument = this.openDocument(fileName, password);
                retVal = (BufferedImage)pdfDocument.getPageImage(page - 1, 1, 2, rotation, 1.0f);
            }
            catch (Exception e) {
                throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error opening pdf document") + " " + fileName.getAbsolutePath(), (Throwable)e);
            }
        } else {
            throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Input file doesn't exists or is a directory"));
        }
        return retVal;
    }

    public int getResolution() {
        return 72;
    }

    public BufferedImage getThumbnail(File inputFile, String password, int page, float resizePercentage) throws ThumbnailCreationException {
        BufferedImage retVal = null;
        if (inputFile != null && inputFile.exists() && inputFile.isFile()) {
            try {
                Document pdfDocument = this.openDocument(inputFile, password);
                retVal = (BufferedImage)pdfDocument.getPageImage(page - 1, 1, 2, 0.0f, resizePercentage);
            }
            catch (Exception e) {
                throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error opening pdf document") + " " + inputFile.getAbsolutePath(), (Throwable)e);
            }
        } else {
            throw new ThumbnailCreationException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Input file doesn't exists or is a directory"));
        }
        return retVal;
    }

    private class ModalSecurityCallbak
    implements SecurityCallback {
        private File inputFile;
        private String password;

        public ModalSecurityCallbak(File inputFile, String password) {
            this.inputFile = inputFile;
            this.password = password;
        }

        @Override
        public String requestPassword(Document document) {
            if (this.password == null) {
                this.password = DialogUtility.askForDocumentPasswordDialog((Component)IcePdfThumbnailsCreator.this.getPanel(), (String)this.inputFile.getName());
                IcePdfThumbnailsCreator.this.setProvidedPassword(this.password);
            }
            return this.password;
        }
    }
}

