/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class COSDictionary
extends COSCompositeObject {
    private final Map objects;

    public static COSDictionary create() {
        return new COSDictionary();
    }

    public static COSDictionary create(int n) {
        return new COSDictionary(n);
    }

    protected COSDictionary() {
        this.objects = new HashMap();
    }

    protected COSDictionary(int n) {
        this.objects = new HashMap(n);
    }

    protected COSDictionary(Map map) {
        this.objects = map;
    }

    @Override
    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromDictionary(this);
    }

    public void addAll(COSDictionary cOSDictionary) {
        this.willChange(this);
        Iterator iterator = cOSDictionary.basicEntryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            COSName cOSName = (COSName)entry.getKey();
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)entry.getValue();
            this.basicPutPropagate(cOSName, cOSDocumentElement.copyShallowNested());
        }
        if (this.objectListeners != null) {
            this.triggerChanged(null, null, null);
        }
    }

    public void addIfAbsent(COSDictionary cOSDictionary) {
        boolean bl = false;
        Iterator iterator = cOSDictionary.basicEntryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            COSName cOSName = (COSName)entry.getKey();
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)entry.getValue();
            if (this.containsKey(cOSName)) continue;
            if (!bl) {
                bl = true;
                this.willChange(this);
            }
            COSObject cOSObject = cOSDocumentElement.copyShallowNested().dereference();
            this.basicPutPropagate(cOSName, cOSObject);
        }
        if (bl && this.objectListeners != null) {
            this.triggerChanged(null, null, null);
        }
    }

    @Override
    public COSDictionary asDictionary() {
        return this;
    }

    protected void basicClearPropagate() {
        for (COSDocumentElement cOSDocumentElement : this.objects.values()) {
            COSObject cOSObject = cOSDocumentElement.dereference();
            this.willChange(cOSObject);
            ICOSContainer iCOSContainer = cOSDocumentElement.removeContainer(this);
            cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        }
        this.objects.clear();
    }

    public Iterator basicEntryIterator() {
        return this.objects.entrySet().iterator();
    }

    public COSDocumentElement basicGet(COSName cOSName) {
        return (COSDocumentElement)this.objects.get(cOSName);
    }

    public Iterator basicIterator() {
        return this.objects.values().iterator();
    }

    protected COSDocumentElement basicPutPropagate(COSName cOSName, COSDocumentElement cOSDocumentElement) {
        COSObject cOSObject = cOSDocumentElement.dereference();
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        this.willChange(cOSObject);
        ICOSContainer iCOSContainer = cOSDocumentElement2.addContainer(this);
        COSDocumentElement cOSDocumentElement3 = this.objects.put(cOSName, cOSDocumentElement2);
        cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        if (cOSDocumentElement3 != null && cOSDocumentElement3 != cOSDocumentElement2) {
            COSObject cOSObject2 = cOSDocumentElement3.dereference();
            this.willChange(cOSObject2);
            iCOSContainer = cOSDocumentElement3.removeContainer(this);
            cOSObject2.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        }
        return cOSDocumentElement3;
    }

    public COSDocumentElement basicPutSilent(COSName cOSName, COSDocumentElement cOSDocumentElement) {
        COSDocumentElement cOSDocumentElement2 = cOSDocumentElement.containable();
        cOSDocumentElement2.addContainer(this);
        COSDocumentElement cOSDocumentElement3 = this.objects.put(cOSName, cOSDocumentElement2);
        if (cOSDocumentElement3 != null && cOSDocumentElement3 != cOSDocumentElement2) {
            cOSDocumentElement3.removeContainer(this);
        }
        return cOSDocumentElement3;
    }

    protected COSDocumentElement basicRemovePropagate(COSName cOSName) {
        COSDocumentElement cOSDocumentElement = (COSDocumentElement)this.objects.remove(cOSName);
        if (cOSDocumentElement == null) {
            return null;
        }
        COSObject cOSObject = cOSDocumentElement.dereference();
        this.willChange(cOSObject);
        ICOSContainer iCOSContainer = cOSDocumentElement.removeContainer(this);
        cOSObject.triggerChanged(COSObject.SLOT_CONTAINER, null, iCOSContainer);
        return cOSDocumentElement;
    }

    public COSDocumentElement basicRemoveSilent(COSName cOSName) {
        COSDocumentElement cOSDocumentElement = (COSDocumentElement)this.objects.remove(cOSName);
        if (cOSDocumentElement == null) {
            return null;
        }
        cOSDocumentElement.removeContainer(this);
        return cOSDocumentElement;
    }

    @Override
    protected String basicToString() {
        return this.objects.toString();
    }

    public void clear() {
        this.willChange(this);
        this.basicClearPropagate();
        if (this.objectListeners != null) {
            this.triggerChanged(null, null, null);
        }
    }

    public boolean containsKey(COSName cOSName) {
        return this.objects.containsKey(cOSName);
    }

    public boolean containsValue(COSObject cOSObject) {
        Iterator iterator = this.entryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            COSObject cOSObject2 = (COSObject)entry.getValue();
            if (!cOSObject2.equals(cOSObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected COSObject copyBasic() {
        return COSDictionary.create(this.size());
    }

    @Override
    public COSObject copyDeep(Map map) {
        COSDictionary cOSDictionary = (COSDictionary)super.copyDeep(map);
        for (Map.Entry entry : this.objects.entrySet()) {
            COSName cOSName = (COSName)entry.getKey();
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)entry.getValue();
            COSObject cOSObject = cOSDocumentElement.copyDeep(map);
            cOSDictionary.basicPutSilent(cOSName, cOSObject);
        }
        return cOSDictionary;
    }

    @Override
    public COSObject copyShallow() {
        COSDictionary cOSDictionary = (COSDictionary)super.copyShallow();
        Iterator iterator = this.basicEntryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            COSName cOSName = (COSName)entry.getKey();
            COSDocumentElement cOSDocumentElement = (COSDocumentElement)entry.getValue();
            cOSDictionary.basicPutSilent(cOSName, cOSDocumentElement.copyShallowNested());
        }
        return cOSDictionary;
    }

    @Override
    protected COSObject copySubGraph(Map map) {
        COSDictionary cOSDictionary = (COSDictionary)super.copySubGraph(map);
        return cOSDictionary;
    }

    public Iterator entryIterator() {
        return new Iterator(){
            private Iterator it;
            {
                this.it = COSDictionary.this.getObjects().entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object next() {
                Map.Entry entry = (Map.Entry)this.it.next();
                return new Entry((COSName)entry.getKey(), (COSDocumentElement)entry.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object object) {
        return this.equals(object, new HashSet());
    }

    @Override
    protected boolean equals(Object object, Set set) {
        if (this.isIndirect()) {
            if (set.contains(this.getIndirectObject())) {
                return true;
            }
            set.add(this.getIndirectObject());
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof COSDictionary)) {
            return false;
        }
        COSDictionary cOSDictionary = (COSDictionary)object;
        if (this.size() != cOSDictionary.size()) {
            return false;
        }
        for (COSName cOSName : this.keySet()) {
            COSObject cOSObject = this.get(cOSName);
            COSObject cOSObject2 = ((COSDocumentElement)cOSObject).dereference();
            COSObject cOSObject3 = cOSDictionary.get(cOSName);
            COSObject cOSObject4 = ((COSDocumentElement)cOSObject3).dereference();
            if (cOSObject2 == null && cOSObject4 != null) {
                return false;
            }
            if (cOSObject2.equals(cOSObject4, set)) continue;
            return false;
        }
        return true;
    }

    public COSObject get(COSName cOSName) {
        COSDocumentElement cOSDocumentElement = this.basicGet(cOSName);
        return cOSDocumentElement == null ? COSNull.NULL : cOSDocumentElement.dereference();
    }

    protected Map getObjects() {
        return this.objects;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private Iterator i;
            {
                this.i = COSDictionary.this.getObjects().values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                return ((COSDocumentElement)this.i.next()).dereference();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public COSObject keyOf(COSObject cOSObject) {
        Iterator iterator = this.entryIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            COSObject cOSObject2 = (COSObject)entry.getValue();
            if (!cOSObject2.equals(cOSObject)) continue;
            return (COSName)entry.getKey();
        }
        return COSNull.NULL;
    }

    public Set keySet() {
        return this.objects.keySet();
    }

    public COSObject put(COSName cOSName, COSObject cOSObject) {
        if (cOSObject == null) {
            return this.remove(cOSName);
        }
        this.willChange(this);
        COSDocumentElement cOSDocumentElement = this.basicPutPropagate(cOSName, cOSObject);
        COSObject cOSObject2 = null;
        cOSObject2 = cOSDocumentElement == null ? COSNull.NULL : cOSDocumentElement.dereference();
        if (this.objectListeners != null) {
            this.triggerChanged(cOSName, cOSObject2, cOSObject);
        }
        return cOSObject2;
    }

    @Override
    public COSIndirectObject referenceIndirect(COSObject cOSObject) {
        COSIndirectObject cOSIndirectObject = super.referenceIndirect(cOSObject);
        for (Map.Entry entry : this.objects.entrySet()) {
            if (entry.getValue() != cOSObject) continue;
            entry.setValue(cOSIndirectObject);
            break;
        }
        return cOSIndirectObject;
    }

    public COSObject remove(COSName cOSName) {
        COSObject cOSObject;
        this.willChange(this);
        COSDocumentElement cOSDocumentElement = this.basicRemovePropagate(cOSName);
        if (cOSDocumentElement == null) {
            cOSObject = COSNull.NULL;
        } else {
            cOSObject = cOSDocumentElement.dereference();
            if (this.objectListeners != null) {
                this.triggerChanged(cOSName, cOSObject, COSNull.NULL);
            }
        }
        return cOSObject;
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        this.objects.clear();
        this.objects.putAll(((COSDictionary)object).objects);
        this.triggerChanged(null, null, null);
    }

    public Object saveState() {
        COSDictionary cOSDictionary = new COSDictionary(new HashMap(this.objects));
        cOSDictionary.container = this.container.saveStateContainer();
        return cOSDictionary;
    }

    public int size() {
        return this.objects.size();
    }

    public List values() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static class Entry
    implements Map.Entry {
        private COSName key;
        private COSDocumentElement value;

        public Entry(COSName cOSName, COSDocumentElement cOSDocumentElement) {
            this.key = cOSName;
            this.value = cOSDocumentElement;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value.dereference();
        }

        public Object setValue(Object object) {
            this.value = (COSDocumentElement)object;
            return this.value;
        }
    }
}

