/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.crypt.AbstractSecurityHandler;
import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.AccessPermissionsNone;
import de.intarsys.pdf.crypt.AuthenticationHandlerFactory;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.IAccessPermissionsSupport;
import de.intarsys.pdf.crypt.IAuthenticationHandler;
import de.intarsys.pdf.crypt.PermissionFlags;
import de.intarsys.pdf.crypt.StandardSecurityHandlerFactory;
import de.intarsys.pdf.st.STDocument;

public abstract class StandardSecurityHandler
extends AbstractSecurityHandler
implements IAccessPermissionsSupport {
    public static final int DEFAULT_ACCESS_PERMISSIONS = -4;
    public static final COSName DK_EncryptMetadata = COSName.constant("EncryptMetadata");
    public static final COSName DK_O = COSName.constant("O");
    public static final COSName DK_P = COSName.constant("P");
    public static final COSName DK_R = COSName.constant("R");
    public static final COSName DK_U = COSName.constant("U");
    protected static byte[] PADDING;
    protected static byte[] USER_R3_PADDING;
    private IAccessPermissions accessPermissions = AccessPermissionsFull.get();
    private IAuthenticationHandler authenticationHandler;
    private byte[] cryptKey;
    private byte[] owner;
    private byte[] user;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 40;
        byArray[1] = -65;
        byArray[2] = 78;
        byArray[3] = 94;
        byArray[4] = 78;
        byArray[5] = 117;
        byArray[6] = -118;
        byArray[7] = 65;
        byArray[8] = 100;
        byArray[10] = 78;
        byArray[11] = 86;
        byArray[12] = -1;
        byArray[13] = -6;
        byArray[14] = 1;
        byArray[15] = 8;
        byArray[16] = 46;
        byArray[17] = 46;
        byArray[19] = -74;
        byArray[20] = -48;
        byArray[21] = 104;
        byArray[22] = 62;
        byArray[23] = -128;
        byArray[24] = 47;
        byArray[25] = 12;
        byArray[26] = -87;
        byArray[27] = -2;
        byArray[28] = 100;
        byArray[29] = 83;
        byArray[30] = 105;
        byArray[31] = 122;
        PADDING = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 40;
        byArray2[1] = -65;
        byArray2[2] = 78;
        byArray2[3] = 94;
        byArray2[4] = 78;
        byArray2[5] = 117;
        byArray2[6] = -118;
        byArray2[7] = 65;
        byArray2[8] = 100;
        byArray2[10] = 40;
        byArray2[11] = -65;
        byArray2[12] = 78;
        byArray2[13] = 94;
        byArray2[14] = 78;
        byArray2[15] = 78;
        USER_R3_PADDING = byArray2;
    }

    public void apply() throws COSSecurityException {
        byte[] byArray = this.createOwnerPassword(this.owner, this.user);
        COSString cOSString = COSString.create(byArray);
        this.getEncryption().cosSetField(DK_O, cOSString);
        byte[] byArray2 = this.createUserPassword(this.user);
        COSString cOSString2 = COSString.create(byArray2);
        this.getEncryption().cosSetField(DK_U, cOSString2);
        this.setCryptKey(this.createCryptKey(this.getUser()));
    }

    @Override
    public void attach(STDocument sTDocument) {
        super.attach(sTDocument);
        if (sTDocument == null) {
            return;
        }
        COSEncryption cOSEncryption = this.getEncryption();
        cOSEncryption.cosSetField(COSEncryption.DK_Filter, StandardSecurityHandlerFactory.CN_Standard);
        cOSEncryption.cosSetField(DK_R, COSInteger.create(this.getRevision()));
        this.getEncryption().setFieldInt(DK_P, -4);
    }

    @Override
    public final void authenticate() throws COSSecurityException {
        this.setActiveAccessPermissions(AccessPermissionsNone.get());
        if (this.authenticationHandler == null) {
            this.authenticationHandler = AuthenticationHandlerFactory.get().createAuthenticationHandler(this);
        }
        this.authenticationHandler.authenticate(this);
    }

    public abstract boolean authenticateOwner(byte[] var1) throws COSSecurityException;

    public abstract boolean authenticateUser(byte[] var1) throws COSSecurityException;

    public int basicGetPermissionFlags() {
        return this.getEncryption().getFieldInt(DK_P, -4);
    }

    public void basicSetPermissionFlags(int n) throws COSSecurityException {
        if (this.getEncryption().cosGetDoc() == null) {
            throw new COSSecurityException("document missing");
        }
        this.getEncryption().setFieldInt(DK_P, n);
    }

    protected abstract IAccessPermissions createAccessPermissions();

    protected abstract byte[] createCryptKey(byte[] var1) throws COSSecurityException;

    protected abstract byte[] createOwnerPassword(byte[] var1, byte[] var2) throws COSSecurityException;

    protected abstract byte[] createUserPassword(byte[] var1) throws COSSecurityException;

    @Override
    public byte[] decrypt(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        throw new COSSecurityException("pluggable encryption not supported");
    }

    @Override
    public void detach(STDocument sTDocument) throws COSSecurityException {
        if (sTDocument == null) {
            return;
        }
        COSEncryption cOSEncryption = this.getEncryption();
        cOSEncryption.cosRemoveField(COSEncryption.DK_Filter);
        cOSEncryption.cosRemoveField(DK_R);
        cOSEncryption.cosRemoveField(DK_P);
        super.detach(sTDocument);
    }

    @Override
    public byte[] encrypt(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        throw new COSSecurityException("pluggable encryption not supported");
    }

    @Override
    public final IAccessPermissions getAccessPermissions() {
        return this.accessPermissions;
    }

    public IAuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    @Override
    public byte[] getCryptKey() {
        return this.cryptKey;
    }

    protected byte[] getO() {
        COSString cOSString = this.getEncryption().cosGetField(DK_O).asString();
        if (cOSString != null) {
            return cOSString.byteValue();
        }
        return null;
    }

    protected byte[] getOwner() {
        return this.owner;
    }

    protected byte[] getPBytes() {
        int n = this.basicGetPermissionFlags();
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((n >>= 8) & 0xFF), (byte)((n >>= 8) & 0xFF), (byte)((n >>= 8) & 0xFF)};
        return byArray;
    }

    protected byte[] getPermanentFileID() throws COSSecurityException {
        COSString cOSString;
        STDocument sTDocument = this.stGetDoc();
        if (sTDocument == null) {
            throw new COSSecurityException("document missing");
        }
        if (sTDocument.getTrailer().cosGetPermanentFileID() == null) {
            sTDocument.getTrailer().updateFileID();
        }
        if ((cOSString = sTDocument.getTrailer().cosGetPermanentFileID()) != null) {
            return cOSString.byteValue();
        }
        return null;
    }

    public PermissionFlags getPermissionFlags() {
        return new PermissionFlags(this);
    }

    public abstract int getRevision();

    protected byte[] getU() {
        COSString cOSString = this.getEncryption().cosGetField(DK_U).asString();
        if (cOSString == null) {
            return null;
        }
        return cOSString.byteValue();
    }

    protected byte[] getUser() {
        return this.user;
    }

    @Override
    public void initialize(STDocument sTDocument) {
        super.initialize(sTDocument);
        this.setActiveAccessPermissions(AccessPermissionsNone.get());
    }

    public boolean isEncryptMetadata() {
        return this.getEncryption().getFieldBoolean(DK_EncryptMetadata, true);
    }

    protected byte[] prepareBytes(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        if (byArray == null) {
            System.arraycopy(PADDING, 0, byArray2, 0, 32);
        } else if (byArray.length > 32) {
            System.arraycopy(byArray, 0, byArray2, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            System.arraycopy(PADDING, 0, byArray2, byArray.length, 32 - byArray.length);
        }
        return byArray2;
    }

    protected void setActiveAccessPermissions(IAccessPermissions iAccessPermissions) {
        this.accessPermissions = iAccessPermissions;
    }

    public void setAuthenticationHandler(IAuthenticationHandler iAuthenticationHandler) {
        this.authenticationHandler = iAuthenticationHandler;
    }

    protected void setCryptKey(byte[] byArray) throws COSSecurityException {
        this.cryptKey = byArray;
    }

    public void setEncryptMetadata(boolean bl) {
        this.getEncryption().setFieldBoolean(DK_EncryptMetadata, bl);
    }

    protected void setOwner(byte[] byArray) {
        this.owner = byArray;
    }

    public void setOwnerPassword(byte[] byArray) throws COSSecurityException {
        if (this.getEncryption().cosGetDoc() == null) {
            throw new COSSecurityException("document missing");
        }
        this.owner = byArray;
    }

    protected void setUser(byte[] byArray) {
        this.user = byArray;
    }

    public void setUserPassword(byte[] byArray) throws COSSecurityException {
        if (this.getEncryption().cosGetDoc() == null) {
            throw new COSSecurityException("document missing");
        }
        this.user = byArray;
    }
}

