/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDShadingPattern;
import de.intarsys.pdf.pd.PDTilingPattern;

public abstract class PDPattern
extends PDObject {
    public static final COSName CN_Type_Pattern = COSName.constant("Pattern");
    public static final COSName DK_Matrix = COSName.constant("Matrix");
    public static final COSName DK_PatternType = COSName.constant("PatternType");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final int PATTERN_TYPE_SHADING = 2;
    public static final int PATTERN_TYPE_TILING = 1;

    protected PDPattern(COSObject cOSObject) {
        super(cOSObject);
    }

    public abstract int getPatternType();

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Pattern;
    }

    public CDSMatrix getMatrix() {
        return CDSMatrix.createFromCOS(this.cosGetField(DK_Matrix).asArray());
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Class<?> getRootClass() {
            return PDPattern.class;
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            COSDictionary cOSDictionary = cOSObject instanceof COSStream ? ((COSStream)cOSObject).getDict() : cOSObject.asDictionary();
            int n = cOSDictionary.get(DK_PatternType).asInteger().intValue();
            switch (n) {
                case 1: {
                    return PDTilingPattern.META;
                }
                case 2: {
                    return PDShadingPattern.META;
                }
            }
            cOSObject.handleException(new COSRuntimeException("unsupported pattern type " + n));
            return null;
        }
    }
}

